/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.web;

import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

/**
 * This is the descriptor class for the tag element of the taglib root element
 * for a .tld file used in a jsp.
 */
public class TagDescriptor {
    Node node;
    public static final String TAG_CLASS_NAME = "tag-class"; // NOI18N
    public static final String TAG_CLASS_1_1_NAME = "tagclass"; // NOI18N
    public static final String DYNAMIC_ATTRIB = "dynamic-attributes"; // NOI18N
    public static final String _FALSE = "false"; // NOI18N
    public static final String TAG_NAME = "name"; // NOI18N

    public TagDescriptor (Node n) {
        this.node=n;
    }

    /**
     * <tag-class>className<tag-class>
     * @return class name as String
     */
    public String getTagClass() {
        NodeList n1 = node.getChildNodes();
        String className = null;
        for (int k = 0; k < n1.getLength(); k++) {
            String name = n1.item(k).getNodeName();
            if (name == TAG_CLASS_NAME || name == TAG_CLASS_1_1_NAME) {
                className = n1.item(k).getFirstChild().getNodeValue();
            }
        }
        return className;
    }

    /**
     *
     * @return dynamic-attributes value defined for a tag
     */
    public String getDynamicAttributes() {
        NodeList n1 = node.getChildNodes();
        String dynAttr = _FALSE;
        for (int k = 0; k < n1.getLength(); k++) {
            String name = n1.item(k).getNodeName();
            if (name == DYNAMIC_ATTRIB) {
                dynAttr = n1.item(k).getFirstChild().getNodeValue();
            }
        }
        return dynAttr;
    }

    /**
     *
     * @return name of the tag
     */
    public String getTagName() {
        NodeList n1 = node.getChildNodes();
        String tagName = null;
        for (int k = 0; k < n1.getLength(); k++) {
            String name = n1.item(k).getNodeName();
            if (name == TAG_NAME) {
                 tagName = n1.item(k).getFirstChild().getNodeValue();
            }
        }
        return tagName;
    }
}
