/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.PrintStream;

/**
 * InsnTarget is a pseudo-instruction which represents a branch target
 * in an instruction stream.
 */

public class InsnTarget extends Insn {

  private boolean branchTarget = false;

  public int nStackArgs() {
    return 0;
  }

  public int nStackResults() {
    return 0;
  }

  public String argTypes() {
      return "";//NOI18N
  }

  public String resultTypes() {
      return "";//NOI18N
  }

  public boolean branches() {
    return false;
  }

  public void setBranchTarget() {
    branchTarget = true;
  }

  /* not valid unless method instructions processed specially */
  public boolean isBranchTarget() {
    return branchTarget;
  }

  /**
   * Constructor
   */
  public InsnTarget() {
    super(opc_target, NO_OFFSET);
  }

  /* package local methods */

  void print (PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println(offset() + ":");//NOI18N
  }

  int store(byte buf[], int index) {
    return index;
  }

  int size() {
    return 0;
  }

  InsnTarget(int offset) {
    super(opc_target, offset);
  }

}

