/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.util;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import java.io.*;

/**
 * ZipFileRegistry provides a central point for lookup of zip files
 * within the filter tool.  It needs to be public because it's
 * accessed from outside the filter.util package.
 */

public
class ZipFileRegistry {
  /* A mapping of file name to ZipFile */
  private static Hashtable zipFileMap = new Hashtable(11); 

  /**
   * Return a zip file which may already be open
   */
  public static ZipFile openZipFile(File f)
    throws FileNotFoundException, IOException {
    ZipFile zf = (ZipFile) zipFileMap.get(f.getPath());
    if (zf == null) {
      zf = new ZipFile(f);
      zipFileMap.put(zf.getName(), zf);
    }
    return zf;
  }

  /**
   * Return a zip file which must already be open
   */
  public static ZipFile getZipFile(String path) {
    return (ZipFile) zipFileMap.get(path);
  }

  /**
   * Returns an enumeration of the zip files in the registry
   * Each element is a ZipFile.
   */
  public static Enumeration zipFiles() {
    return zipFileMap.elements();
  }
  
}
