/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.spi.persistence.support.sqlstore;

/**
 * Interface to access SQLStore config information.
 *
 * @author Marina Vatkina
 */ 
public interface ConfigCache {

    /**
     * Get the PersistenceConfig for given pcClass. The config is looked up
     * from a cache. If a config can not be found in cache, a new
     * instance is created and returned.
     *
     * @param pcClass The input pcClass.
     * @return PersistenceConfig for given pcClass.
     */
    PersistenceConfig getPersistenceConfig(Class pcClass);

    /**
     * Gets the Class instance corresponding to given oidType.
     *
     * @param oidType The input oidType.
     * @return The Class instance corresponding to given oidType.
     */
    Class getClassByOidClass(Class oidType);

    /**
     * Sets VersionConsistencyCache field.
     *   
     * @param vcCache the VersionConsistencyCache instance.
     */  
    void setVersionConsistencyCache(VersionConsistencyCache vcCache);
}
