/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MathType.java
 *
 * Created on August 24, 2001
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import java.math.BigDecimal;
import java.math.BigInteger;

/** 
 * This class represents the types java.math.BigDecimal and java.math.BigInteger.
 *
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class MathType
    extends ClassType
    implements NumberType
{
    /**
     *
     */
    public MathType(String name, Class clazz, int enumType, TypeTable typetab)
    {
        super(name, clazz, enumType, typetab);
    }
    
    /**
     * A numeric wrapper class type defines an ordering.
     */
    public boolean isOrderable()
    {
        return true;
    }

    /**
     * Converts the specified value into a value of this numeric type.
     * E.g. an Integer is converted into a BigDecimal, if this represents 
     * the type BigDecimal.
     * @param value value to be converted
     * @return converted value
     */
    public Number getValue(Number value)
    {
        Number ret = null;

        if (value == null)
            ret = null;
        else if ("java.math.BigDecimal".equals(getName()))
        {
            if (value instanceof BigDecimal)
                ret = value;
            else if (value instanceof BigInteger)
                ret = new BigDecimal((BigInteger)value);
            else if (value instanceof Double)
                ret = new BigDecimal(((Double)value).toString());
            else if (value instanceof Float)
                ret = new BigDecimal(((Float)value).toString());
            else if (value instanceof Number)
                ret = BigDecimal.valueOf(((Number)value).longValue());
        }
        else if ("java.math.BigInteger".equals(getName()))
        {
            if (value instanceof BigInteger)
                ret = value;
            else if (value instanceof Double)
                ret = (new BigDecimal(((Double)value).toString())).toBigInteger();
            else if (value instanceof Float)
                ret = (new BigDecimal(((Float)value).toString())).toBigInteger();
            else if (value instanceof Number)
                ret = BigInteger.valueOf(((Number)value).longValue());
        }
        
        return ret;
    }

    /**
     * Returns -value. 
     * @param value value to be negated
     * @return -value
     */
    public Number negate(Number value)
    {
        Number ret = null;

        if (value == null)
            ret = null;
        else if ("java.math.BigDecimal".equals(getName()))
        {
            if (value instanceof BigDecimal)
                ret = ((BigDecimal)value).negate();
            else if (value instanceof BigInteger)
                ret = new BigDecimal(((BigInteger)value).negate());
            else if (value instanceof Double)
                ret = (new BigDecimal(((Double)value).toString())).negate();
            else if (value instanceof Float)
                ret = (new BigDecimal(((Float)value).toString())).negate();
            else if (value instanceof Number)
                ret = BigDecimal.valueOf(-((Number)value).longValue());
        }
        else if ("java.math.BigInteger".equals(getName()))
        {
            if (value instanceof BigInteger)
                ret = ((BigInteger)value).negate();
            else if (value instanceof Double)
                ret = (new BigDecimal(((Double)value).toString())).negate().toBigInteger();
            else if (value instanceof Float)
                ret = (new BigDecimal(((Float)value).toString())).negate().toBigInteger();
            else if (value instanceof Number)
                ret = BigInteger.valueOf(-((Number)value).longValue());
        }
        
        return ret;
    }
    
}
