/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Type.java
 *
 * Created on March 8, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.spi.persistence.utility.FieldTypeEnumeration;

/**
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public abstract class Type
{
    /**
     * The name of the type represented by this object.
     */
    protected String name;

    /**
     * The corresponding class object.
     */
    protected Class clazz;

    /**
     * The FieldTypeEnumeration constant for this Type.
     */
    protected int enumType;

    /**
     * Creates a new Type object with the specified name.
     * @param name name of the type represented by this
     * @param clazz the class object for this type
     */
    public Type(String name, Class clazz)
    {
        this(name, clazz, FieldTypeEnumeration.NOT_ENUMERATED);
    }

    /**
     * Creates a new Type object with the specified name.
     * @param name name of the type represented by this
     * @param clazz the class object for this type
     * @param enumType the FieldTypeEnumeration value for this type
     */
    public Type(String name, Class clazz, int enumType)
    {
        this.name = name;
        this.clazz = clazz;
        this.enumType = enumType;
    }

    /**
     * Returns the name of the type.
     */
    public String getName()
    {
        return name;
    }

    /**
     * Returns the corresponding class object.
     */
    public Class getJavaClass() {
        return this.clazz;
    }

    /**
     * Checks type compatibility.
     * @param type the type this is checked with.
     * @return true if this is compatible with type;
     * false otherwise.
     */
    public abstract boolean isCompatibleWith(Type type);

    /**
     * Returns whether this represents a type with an
     * defined order.
     * @return true if an order is defined for this;
     * false otherwise.
     */
    public boolean isOrderable()
    {
        return false;
    }

    /**
     * Returns the FieldTypeEnumeration value for this type.
     */
    public int getEnumType()
    {
        return enumType;
    }

    /**
     * Representation of this type as a string.
     */
    public String toString()
    {
        return getName();
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     *
     * Two types are equal if their names are equal.
     */
    public boolean equals(Object obj)
    {
        if (obj == this)
            return true;
        else if (obj instanceof Type)
            return this.name.equals(((Type)obj).name);
        else
            return false;
    }


}
