/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConstraintParamIndex.java
 *
 * Created on March 12, 2002
 * @author  Daniel Tonn
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint;

import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;

/**
 * Constraint which represent an index of a query parameter.
 * This index is put to the stack and used
 * to bind the real value of the parameter to the query.
 */
public class ConstraintParamIndex extends ConstraintValue
{

    /**
     * com.sun.jdo.spi.persistence.utility.FieldTypeEnumeration constant
     * for type of this parameter.
     *
     */
    int enumType;

    /**
     * Constructor.
     * @param index parameter index
     * @param enumType type of this parameter
     * @param localField the localField to which this parameter is bound.
     */
    public ConstraintParamIndex(int index, int enumType, LocalFieldDesc localField) {
        super(new Integer(index), localField);
        this.enumType = enumType;
    }

    /**
     * Get type of this parameter.
     */
    public int getType() {
        return enumType;
    }
    
    public Integer getIndex() {
        return (Integer) getValue();
    }

}
