/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth.callback;

import javax.security.auth.Subject;
import javax.security.auth.kerberos.*;
import javax.security.auth.callback.Callback;

/**
 * Callback for Kerberos Key.
 *
 * @version 1.4, 03/03/04
 */
public class KerberosKeyCallback implements Callback {

    private KerberosPrincipal owner;
    private KerberosKey key;

    /**
     * Constructs this KerberosSubjectCallback with a KerberosPrincipal.
     *
     * <p> The <i>owner</i> input parameter
     * specifies the owner of the KerberosKey to be returned.
     *
     * @param owner the owner of the KerberosKey to be returned
     */
    public KerberosKeyCallback(KerberosPrincipal owner) {
	this.owner = owner;
    }

    /**
     * Get the owner.
     *
     * @return the owner
     */
    public KerberosPrincipal getOwner() {
	return owner;
    }

    /**
     * Set the requested Kerberos key.
     *
     * @param key the Kerberos key
     */
    public void setKey(KerberosKey key) {
	this.key = key;
    }

    /**
     * Get the requested Kerberos key.
     *
     * @return the Kerberos key
     */
    public KerberosKey getKey() {
	return key;
    }
}
