/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.enterprise.deploy.model;

import java.beans.PropertyChangeEvent;

/**
 * An Event class describing ConfigBeans being added/subtracted
 * from a server configuration.
 */
public final class XpathEvent {

   private final DDBean bean;
   private final Object typ;
   private PropertyChangeEvent changeEvent;

   /**
    * Adding a DDBean
    */   
   public static final Object BEAN_ADDED = new Object();
   /**
    * Removing a DDBean
    */   
   public static final Object BEAN_REMOVED = new Object();
   /**
    * Changing a DDBean
    */
   public static final Object BEAN_CHANGED = new Object();

   /**
    * A description of a change in the ConfigBean tree.
    * @param bean The ConfigBean being added/removed.
    * @param typ Indicates an add/remove event.
    */   
   public XpathEvent(DDBean bean, Object typ) {
       this.bean = bean; this.typ = typ;
       }

   public PropertyChangeEvent getChangeEvent() {
       if(typ == BEAN_CHANGED) return changeEvent;
       return null;
   }
   
   public void setChangeEvent(PropertyChangeEvent pce) {
       changeEvent = pce;
   }
   
       /**
        * The bean being added/removed/changed.
        * @return The bean being added/removed/changed.
        */       
   public DDBean getBean() {return bean;}

   /** Is this an add event?
    * @return true if this is an add event.
    */   
   public boolean isAddEvent() {return typ == BEAN_ADDED;}

   /** Is this a remove event?
    * @return true if this is a remove event.
    */   
   public boolean isRemoveEvent() {return typ == BEAN_REMOVED;}

   /** Is this a change event?
    * @return true if this is a change event.
    */   
   public boolean isChangeEvent() {return typ == BEAN_CHANGED;}

   }
