/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.ejb.cmp3;

import java.util.Collection;
import oracle.toplink.essentials.queryframework.DatabaseQuery;

/**
 * PUBLIC:
 * TopLInk specific EJB 3.0 query interface.  Provides the functionality defined in
 * javax.persistence.Query and adds access to the underlying database query for TopLink specific
 * functionality.
 */
public interface EJBQuery extends javax.persistence.Query {
    public static final String CACHE_USAGE = "toplink.cache-usage";
    public static final String CALL = "toplink.call";
    public static final String CASCADE_LEVEL = "toplink.cascade";
    public static final String EXPRESSION = "toplink.expression";
    public static final String LOCK_MODE = "toplink.pessimistic-lock";
    public static final String REFERENCE_CLASS = "toplink.reference-class";
    public static final String REFRESH = "toplink.refresh";

    /**
     * PUBLIC:
     * Return the cached database query for this EJBQueryImpl.  If the query is
     * a named query and it has not yet been looked up, the query will be looked up
     * and stored as the cached query.
     */
    public DatabaseQuery getDatabaseQuery();

    /**
     * PUBLIC:
     * return the EntityManager for this query
     */
    public EntityManager getEntityManager();

    /**
     * PUBLIC:
     * Non-standard method to return results of a ReadQuery that has a containerPoliry
     * that returns objects as a collection rather than a List
     * @return Collection of results
     */
    public Collection getResultCollection();

    /**
     * PUBLIC:
     * Replace the cached query with the given query.
     */
    public void setDatabaseQuery(DatabaseQuery query);

}
