/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.jdbc.base;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;

/**
 * A simple invocation handler for the proxied connection.
 *
 * Connections are proxied only when they are obtained from a
 * transactional data source and within the context of a JTA
 * transaction.
 */
public class ConnectionProxyHandler implements InvocationHandler {
    Connection connection;

    /************************/
    /***** Internal API *****/
    /************************/
    private void debug(String s) {
        System.out.println(s);
    }

    /*
     * Use this constructor
     */
    public ConnectionProxyHandler(Connection connection) {
        this.connection = connection;
    }

    /*********************************/
    /***** InvocationHandler API *****/
    /*********************************/

    /*
     * Gateway for method interception
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        debug("PROXY method: " + methodName);
        // No-op if any of the following calls
        if (methodName.equals("close") || methodName.equals("commit") || methodName.equals("rollback")) {
            return null;
        }

        // Normal case is just to forward on to the real connection
        return method.invoke(connection, args);
    }
}
