/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.lang.Boolean;

/**
 * Common metatata accessor for the annotation and xml processors.
 * 
 * @author Guy Pelletier, Dave McCann
 * @since TopLink EJB 3.0 Reference Implementation
 */
public abstract class MetadataAccessor  {
    protected Class m_rawClass;
    protected Class m_referenceClass;
    protected String m_attributeName;
    protected Boolean m_isRelationship;
    protected boolean m_needsProcessing;
    protected MetadataProcessor m_metadataProcessor;
    protected MetadataDescriptor m_metadataDescriptor;

    /**
     * INTERNAL:
     * Return the attribute name for this accessor.
     */
    public String getAttributeName() {
        return m_attributeName;
    }
    
    /**
     * INTERNAL:
     */
    public abstract Object getAnnotatedElement();
    
    /**
     * INTERNAL:
     * Return the metadata descriptor for this accessor.
     */
    public abstract MetadataDescriptor getMetadataDescriptor();
    
    /**
     * INTERNAL:
     * Return the java class that defines this accessor.
     */
    public Class getJavaClass() {
        return m_metadataDescriptor.getJavaClass();
    }
    
    /**
     * INTERNAL:
     * Return the java class that defines this accessor.
     */
    public String getJavaClassName() {
        return getJavaClass().getName();
    }

    /**
     * INTERNAL:
     * Returns the name of this accessor. For annotations - if it is a field, it 
     * will return the field name, and for a method it will return the method 
     * name. For XML, it will return the field name is access-type is FIELD, and 
     * a generated 'get' method name if PROPERTY.
     */
    public abstract String getName();

    /**
     * INTERNAL:
     * Return the raw class for this accessor. 
     */
    public abstract Class getRawClass();
    
    /**
     * INTERNAL:
     * Return the reference class for this accessor.
     */
    public abstract Class getReferenceClass();

    /**
     * INTERNAL:
     * Return the reference class name for this accessor.
     */
    public String getReferenceClassName() {
        return getReferenceClass().getName();
    }
    
    /**
     * INTERNAL:
     * Return the reference metadata descriptor for this accessor.
     */
    public MetadataDescriptor getReferenceMetadataDescriptor() {
        return m_metadataProcessor.getMetadataDescriptor(getReferenceClass());
    }
    
    /**
     * INTERNAL:
     * Return the upper cased attribute name for this accessor. Used when
     * defaulting.
     */
    public String getUpperCaseAttributeName() {
        return m_attributeName.toUpperCase();
    }
    
    /**
     * INTERNAL:
	 * Method to check for column.
     */
	public abstract boolean hasColumn();
    
    /**
     * INTERNAL:
	 * Method to check for enumerated.
     */
	public abstract boolean hasEnumerated();
    
    /**
     * INTERNAL:
	 * Method to check for join column.
     */
	public abstract boolean hasJoinColumn();
    
    /**
     * INTERNAL:
	 * Method to check for join columns.
     */
	public abstract boolean hasJoinColumns();
    
    /**
     * INTERNAL:
	 * Method to check for primary key join column.
     */
	public abstract boolean hasPrimaryKeyJoinColumn();
    
    /**
     * INTERNAL:
	 * Method to check for primary key join columns.
     */
	public abstract boolean hasPrimaryKeyJoinColumns();
    
    /**
     * INTERNAL:
	 * Return true if this accessor represents an Sql result set mapping.
     */
	public abstract boolean hasSqlResultSetMapping();
    
    /**
     * INTERNAL:
     * Return true if this accessor represents a temporal mapping.
     */
	public abstract boolean hasTemporal();
    
    /**
     * INTERNAL:
     * Return true if this accessor represents an aggregate mapping.
     */
	public abstract boolean isEmbedded();
    
    /**
     * INTERNAL:
     * Return true if this accessor represents an aggregate id mapping.
     */
	public abstract boolean isEmbeddedId();
    
    
    /**
     * INTERNAL:
     * Return true if this represents an enum type mapping. Will return true
     * if the accessor's reference class is an enum or if an enumerated 
     * sub-element exists.
     */
     public boolean isEnumerated() {
     	return hasEnumerated() || MetadataHelper.isValidEnumeratedType(getReferenceClass());
     }
     
    /**
     * INTERNAL:
     * Return true if this accessor represents an BLOB/CLOB mapping.
     */
	public abstract boolean isLob();
    
    /**
     * INTERNAL:
     * Return true if this accessor represents a m-m relationship.
     */
	public abstract boolean isManyToMany();
    
    /**
     * INTERNAL:
	 * Return true if this accessor represents a m-1 relationship.
     */
	public abstract boolean isManyToOne();
    
    /**
     * INTERNAL:
	 * Return true if this accessor represents a 1-m relationship.
     */
	public abstract boolean isOneToMany();
    
	/**
     * INTERNAL:
     * Return true if this accessor represents a 1-1 relationship.
     */
	public abstract boolean isOneToOne();

    /**
     * INTERNAL:
     * Return true if this accessor represents a 1-1 primary key relationship.
     */
	public boolean isOneToOnePrimaryKeyRelationship() {
        return isOneToOne() && (hasPrimaryKeyJoinColumns() || hasPrimaryKeyJoinColumn());
    }
	
	/**
     * INTERNAL:
	 * Return true if this accessor method represents a relationship. It will
     * cache the boolean value to avoid multiple checks and validation.
     */
	public boolean isRelationship() {
        if (m_isRelationship == null) {
            m_isRelationship = new Boolean(isManyToOne() || isManyToMany() || isOneToMany() || isOneToOne());
        }
        
        return m_isRelationship.booleanValue(); 
    }
 
    /**
     * INTERNAL:
     * Return true if this accessor represents a serialized mapping.
     */
	public boolean isSerialized() {
        return MetadataHelper.isValidSerializedType(getReferenceClass());
    }
    
    /**
     * INTERNAL:
     * Return true if this accessor represents a temporal mapping.
     */
	public boolean isTemporal() {
		return hasTemporal() || MetadataHelper.isValidTemporalType(getReferenceClass());
    }
    
    /**
     * INTERNAL:
	 * Return true if this accessor represents an optimistic locking field.
     */
	public abstract boolean isVersion();
    
    /**
     * INTERNAL:
	 * Return true if this accessor has not been processed yet.
     */
    public boolean needsProcessing() {
        return m_needsProcessing;    
    }

    /**
     * INTERNAL:
	 * Fast track the processing of this accessor.
     */
    public void process() {
        m_metadataProcessor.processRelationshipAccessor(this);
    }
    
    /**
     * INTERNAL:
	 * Set to true if this processor needs processing.
     */
    public void setNeedsProcessing(boolean value) {
		m_needsProcessing = value;	
	}
    
    /**
     * INTERNAL:
	 * Set the reference class for this accessor.
     */
    public abstract void setReferenceClass(Class potentialReferenceClass, String context);
    
    /**
     * INTERNAL:
	 * Store ourself on our respective metadata descriptor.
     */
    public abstract void store();
}
