/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

/**
 * INTERNAL:
 * Static values for metadata processing.
 * WIP - clean up XMLConstants, MetadataProcessor etc ...
 */
public class MetadataConstants {
    public static final String AUTO = "AUTO";
    public static final String SINGLE_TABLE = "SINGLE_TABLE";
    public static final String TABLE_PER_CLASS = "TABLE_PER_CLASS";
    
    /* Used for setting the discriminator column type. */
    public static final String CHAR = "CHAR";
    public static final String STRING = "STRING";
    public static final String INTEGER = "INTEGER";
    
    /* Used with order by. */
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    
    /* Used with temporal field classifications. */
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    
    /* Used for setting the annotation cascade types. */
    public static final String ALL = "ALL";
    public static final String MERGE = "MERGE";
    public static final String REMOVE = "REMOVE";
    public static final String PERSIST = "PERSIST";
    public static final String REFRESH = "REFRESH";
    
    /* Used for setting the xml cascade types. */
	public static final String CASCADE_ALL = "cascade-all";
    public static final String CASCADE_MERGE = "cascade-merge";
    public static final String CASCADE_REMOVE = "cascade-remove";
    public static final String CASCADE_PERSIST = "cascade-persist";
    public static final String CASCADE_REFRESH = "cascade-refresh";
    
    /* Used for setting the default discriminator column of an inheritance hierarchy. */
    public static final String DEFAULT_DISCRIMINATOR_COLUMN = "DTYPE";
}
