/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import oracle.toplink.essentials.internal.helper.DatabaseField;

/**
 * A helper class used when processing join columns.
 * 
 * @author Guy Pelletier
 * @since TopLink 10.1.3/EJB 3.0 Preview
 */
public class MetadataJoinColumn {
    private DatabaseField m_pkField;
    private DatabaseField m_fkField;
    
    public MetadataJoinColumn() {
        m_pkField = new DatabaseField();
        m_fkField = new DatabaseField();
    }
    
    public DatabaseField getForeignKeyField() {
        return m_fkField;
    }
    
    public DatabaseField getPrimaryKeyField() {
        return m_pkField;
    }
    
    public void setForeignKeyField(DatabaseField fkField) {
        m_fkField = fkField;
    }
    
    public void setPrimaryKeyField(DatabaseField pkField) {
        m_pkField = pkField;
    }
}
