/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.lang.reflect.Method;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

/**
 * This class facilitates collection of an entity class name (the entity is a 
 * listener in this case) and any callback method names that are to be applied.  
 * This is useful in two-phase processing of the XML Descriptor, where the 
 * classloader may change between phases.  Here, phase one would involve 
 * gathering class/method name info and phase two would involve loading the 
 * entity class and setting the callback methods accordingly.
 * 
 * @author Dave McCann, Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLEntityClassListener extends XMLListener {
    /**
     * INTERNAL:
     */
    public XMLEntityClassListener(String entityClassName) {
        super(entityClassName, entityClassName);
    }
    
    /**
     * INTERNAL:
     * Return the listener class. In this case, the entity is itself a listener.
     */
    public Class getListenerClass() {
        return getEntityClass();    
    }
    
    /**
     * INTERNAL:
     * Return the candidate callback methods for this entity.
     */
    protected Method[] getCandidateMethods() {
        return MetadataHelper.getCandidateCallbackMethodsForEntityClass(getEntityClass());
    }
    
    /**
     * INTERNAL:
     * Initialize the listener.  This involves loading the entity and listener
     * classes, creating a listener instance, and setting the methods (listed 
     * as names in the callbackMethodNames list) on the listener class.
     */
    public void initializeCallbackMethods(ClassLoader classLoader) {
        setEntityClass(MetadataHelper.getClassForName(entityClassName, classLoader));
        setMethodsOnListener();
    }

    /**
     * INTERNAL: 
     */
    protected void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        Object[] objectList = {};
        invokeMethod(getEventMethod(event), descriptorEvent.getObject(), objectList, descriptorEvent);
    }
    
    /**
     * INTERNAL:
     */
     public boolean isEntityCBListener() {
        return true;
    }
    
    /**
     * INTERNAL:
     */
    protected void validateMethod(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw ValidationException.invalidEntityCallbackMethodArguments(getEntityClass(), method.getName());
        }
    }
}
