/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  

/* $Header: /cvs/glassfish/entity-persistence/src/java/oracle/toplink/essentials/internal/helper/InvalidObject.java,v 1.1.1.1 2005/10/12 20:18:55 gyorke Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */
/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    pkrogh      10/07/05 - 
    pkrogh      09/29/05 - 
    gyorke      08/09/05 - gyorke_10-essentials-directory-creation_050808
    dmahar      08/04/05 - 
    pkrogh      08/28/04 - codeformat
    smcritch    05/14/04 - smcritch_refactor_session_read031604
    smcritch    04/26/04 - Creation
 */
package oracle.toplink.essentials.internal.helper;


/**
 * <b>Purpose</b>:Indicates an object that should not be returned from
 * query execution.
 * <p>
 * When conforming if checkEarly return finds a matching object by exact primary
 * key, but that object is deleted, want to return null from query execution.
 * <p>
 * However if null is returned from checkEarly return that will indicate that
 * no object was found and to go to the database.  Hence returning null is not
 * enough, something else needed to be returned, indicating not only that
 * checkEarlyReturn had failed but query execution should not proceed.
 * <p>
 * Can be used in other instances where returning null is ambiguous.
 * <p>
 * Implements singleton pattern
 *  @version $Header: /cvs/glassfish/entity-persistence/src/java/oracle/toplink/essentials/internal/helper/InvalidObject.java,v 1.1.1.1 2005/10/12 20:18:55 gyorke Exp $
 *  @author  Stephen McRitchie
 *  @since   release specific (what release of product did this appear in)
 */
public class InvalidObject {
    public static final InvalidObject instance = new InvalidObject();

    private InvalidObject() {
    }

    /**
     * @return singleton invalid object.
     */
    public static InvalidObject instance() {
        return instance;
    }
}
