/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BaicIasBean.java
 *
 * Created on April 4, 2002, 9:47 AM
 */

package com.sun.enterprise.tools.common.beans;

import java.util.ResourceBundle;

import java.beans.PropertyVetoException;
import java.beans.VetoableChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import org.netbeans.modules.schema2beans.BaseBean;
/**
 *
 * @author  vkraemer
 */
public abstract class BasicIasBean {

    protected static VetoableChangeListener greaterThanNegOne =
        new PositiveValueListener();
    protected static VetoableChangeListener notNull =
        new NotEmptyValueListener();

    private PropertyChangeSupport pcs;
    private VetoableChangeSupport vcs;

    protected static ResourceBundle bundle =
        ResourceBundle.getBundle("com.sun.enterprise.tools.common.beans.Bundle"); //NOI18N


    /** Creates a new instance of BaicIasBean */
    protected BasicIasBean() {
    }
    
    public PropertyChangeSupport getPCS() {
        if (null == pcs)
            pcs = new PropertyChangeSupport(this);
        return pcs;
    }
    
    public VetoableChangeSupport getVCS() {
        if (null == vcs)
            vcs = new VetoableChangeSupport(this);
        return vcs;
    }

     protected void doAttrSetProcessing(BaseBean bean, String newVal, String attrName, String propName)
        throws PropertyVetoException {
        String oldName = bean.getAttributeValue(attrName); //NOI18N
        fireMyVetoableChange(propName, oldName, newVal);
        bean.setAttributeValue(attrName,newVal); //NOI18N
        fireMyPropertyChange(propName, oldName, newVal);
    }
     
     protected void doElementSetProcessing(BaseBean bean, String newVal, String subElement, String propName)
        throws PropertyVetoException {
        String oldName = (String) bean.getValue(subElement);
        fireMyVetoableChange(propName, oldName, newVal);
        bean.setValue(subElement,newVal);
        fireMyPropertyChange(propName, oldName, newVal);
    }
     
     protected void doAttrSetProcessing(BaseBean bean, int newVal, String attrName, String propName) 
        throws PropertyVetoException {
        int oldVal = Integer.parseInt(bean.getAttributeValue(attrName)); //NOI18N
        fireMyVetoableChange(propName, oldVal, newVal);
        bean.setAttributeValue(attrName, ""+newVal); //NOI18N
        fireMyPropertyChange(propName, oldVal, newVal);
    }

     protected void fireMyVetoableChange(String name, Object oldV, Object newV) throws PropertyVetoException {
        if (null == vcs) {
            vcs = new VetoableChangeSupport(this);
        }
        vcs.fireVetoableChange(name,oldV,newV);
    }
    
    protected void fireMyVetoableChange(String name, int oldV, int newV) throws PropertyVetoException {
        if (null == vcs) {
            vcs = new VetoableChangeSupport(this);
        }
        vcs.fireVetoableChange(name,oldV,newV);
    }
    
    protected void fireMyPropertyChange(String name, Object oldV, Object newV) { // throws PropertyVetoException {
        if (null == pcs) {
            pcs = new PropertyChangeSupport(this);
        }
        pcs.firePropertyChange(name,oldV,newV);
    }
    
    protected void fireMyPropertyChange(String name, int oldV, int newV) { // throws PropertyVetoException {
        if (null == pcs) {
            pcs = new PropertyChangeSupport(this);
        }
        pcs.firePropertyChange(name,oldV,newV);
    }
        
    /** Add a property listener to this bean.
     * @param pcl PropertyChangeListener to add
     */    
   public void addPropertyChangeListener(PropertyChangeListener pcl) {
       if (null == pcs)
           pcs = new PropertyChangeSupport(this);
       pcs.addPropertyChangeListener(pcl);
   }

   /** Remove this listener.
    * @param pcl Listener to remove.
    */   
   public void removePropertyChangeListener(PropertyChangeListener pcl) {
       if (null != pcs) 
           pcs.removePropertyChangeListener(pcl);
   }

    /** Add a Vetoable listener to this bean.
     * @param pcl VetoableChangeListener to add
     */    
   public void addVetoableChangeListener(VetoableChangeListener pcl) {
       if (null == vcs)
           vcs = new VetoableChangeSupport(this);
       vcs.addVetoableChangeListener(pcl);
   }

   /** Remove this listener.
    * @param pcl Listener to remove.
    */   
   public void removeVetoableChangeListener(VetoableChangeListener pcl) {
       if (null != vcs) 
           vcs.removeVetoableChangeListener(pcl);
   }

   /////////////////////
   
   public abstract void outTo(java.io.OutputStream os) throws java.io.IOException;

   static class PositiveValueListener implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            try {
                Integer valI= (Integer) pce.getNewValue();
                int val = valI.intValue();
                if (0 > val) {
                    String messFormat = bundle.getString("ERROR_MUST_BE_POSITIVE");
                    String mess = java.text.MessageFormat.format(messFormat, new Object[]  { pce.getPropertyName() });
                    throw new PropertyVetoException(mess, pce);
                }
            }
            catch (Throwable t) {
                throw new PropertyVetoException(t.getLocalizedMessage(), pce);
            }
        }
    }
    
   static class NotEmptyValueListener implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            try {
                String val= (String) pce.getNewValue();
                //int val = valI.intValue();
                if (null == val || val.trim().length() == 0) {
                    String messFormat = bundle.getString("ERROR_MUST_HAVE_VALUE");
                    String mess = java.text.MessageFormat.format(messFormat, new Object[]  { pce.getPropertyName() });
                    throw new PropertyVetoException(mess, pce);
                }
            }
            catch (Throwable t) {
                throw new PropertyVetoException(t.getLocalizedMessage(), pce);
            }
        }
    }
   
}
