/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * GenericTableModel.java
 *
 * Created on February 20, 2001, 12:19 AM
 */

package com.sun.enterprise.tools.common.ui;
import javax.swing.table.*;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;

/**
 *
 * @author  bnevins
 * @version 
 */
public class GenericTableModel extends AbstractTableModel
{
	public GenericTableModel(GenericTableInfo info)
	{
		Reporter.assertIt(info); //NOI18N
		tableInfo = info;
		//load();
    }
	
	//////////////////////////////////////////////////////////////
	
	public String getColumnName(int c)
	{  
		return tableInfo.getColumnName(c);
	}
	
	//////////////////////////////////////////////////////////////
	
	public Class getColumnClass(int c)
	{  
		return String.class;
	}
	
	//////////////////////////////////////////////////////////////
	
	public int getColumnCount()
	{  
		return tableInfo.getColumnCount();
	}
	
	//////////////////////////////////////////////////////////////
	
	public int getRowCount()
	{ 
		return tableInfo.getRowCount();
	}
	
	//////////////////////////////////////////////////////////////
	
	public Object getValueAt(int r, int c)
	{  
		return tableInfo.getString(r, c);
	}
	
	//////////////////////////////////////////////////////////////
	
	public void setValueAt(Object obj, int r, int c)
	{  
		Reporter.assertIt(obj instanceof String); //NOI18N
		String s = (String)obj;
		
		tableInfo.setString(r, c, s);
	}
	
	//////////////////////////////////////////////////////////////
	
	public boolean isCellEditable(int r, int c)
	{ 
		boolean b = tableInfo.isColumnEditable(c);
	///	System.out.println("isColEditable for Column " + c + " --- " + b); //NOI18N
		//return tableInfo.isColumnEditable(c);
		return b;
	}
	
	//////////////////////////////////////////////////////////////

	private GenericTableInfo tableInfo = null;
}

