/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.cli;

/**
 *
 * author : Gautam Borah
 *
 */

import java.io.*;
import java.util.*;
import java.util.logging.*;
import com.sun.enterprise.tools.upgrade.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.common.*;
import com.sun.enterprise.cli.framework.*;

public class CLIParser extends ArgsParser implements InteractiveInput {
    
    private StringManager sm;
    
    private boolean interactiveInput = false;
    private Map interactiveInputMap;
    private String currentDomain;
    private int index=0;
    private CommonInfoModel commonInfo;
    private ArgsParser parser;
    
    public CLIParser(){
        this(new CommonInfoModel(), new String [] {});
    }
    
    public CLIParser(CommonInfoModel cim, String [] args) {
        super(args, cim);
        commonInfo = cim;
        sm = StringManager.getManager(LogService.UPGRADE_CLI_LOGGER);
        interactiveInputMap = parse(this);
        verifyCommonInfo(commonInfo);
        if(!commonInfo.isUpgradeSupported()) {
            getLogger().info(sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported") +
                    commonInfo.getSourceVersionAndEdition() + " -> " + commonInfo.getTargetVersionAndEdition());
            System.exit(1);
        }
        commonInfo.enlistDomainsFromSource();
    }
    
    public void setCommonInfoModel(CommonInfoModel commonInfo){
        this.commonInfo=commonInfo;
    }
    
    public CommonInfoModel getCommonInfoModel(CommonInfoModel commonInfo){
        return commonInfo;
    }
    
    public void printInfo(){
        commonInfo.printInfo();
    }
    
    public Logger getLogger() {
        return LogService.getLogger(LogService.UPGRADE_LOGGER);
    }
    
    public void parseComandLineArguments(String[] args) {
        parser = new ArgsParser(args, commonInfo);
        interactiveInputMap = parser.parse(this);
        verifyCommonInfo(commonInfo);
        if(!commonInfo.isUpgradeSupported()) {
            getLogger().info(sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported") +
                    commonInfo.getSourceVersionAndEdition() + " -> " + commonInfo.getTargetVersionAndEdition());
            System.exit(1);
        }
        commonInfo.enlistDomainsFromSource();
    }
    
    public void collectMissingArguments(Map inputMap)  {
        if(inputMap.containsKey("noprompt"))
            return;
        List domainList = commonInfo.getDomainList();
        
        // Following are Invalid Input for Interaction
        //If either source is null but domain name is not null
        //If either nsspwd, jkdpwd, capwd not null but domain name is null
        Iterator itr =  domainList.iterator();
        while(itr.hasNext()) {
            String domainName = (String)itr.next();
            String suffix = "-" + domainName;
            if( inputMap.get(SOURCE) == null && inputMap.get(SOURCE_SHORT) == null
                    && inputMap.get(DOMAIN+suffix) != null)  {
                helpUsage();
                System.exit(1);
            }
        }
        
        if(inputMap.get(SOURCE) == null && inputMap.get(SOURCE_SHORT) == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.Source_input"));
            byte b[] = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) { // input stream closed, maybe by ^C
                    System.exit(1);
                }
                String sourceDir = new String(b,0,c);
                String source = sourceDir.trim();
                File biDir = new File(source+File.separator+"bin");
                if(source.equals("") || !biDir.isDirectory()) {
                    if(!(commonInfo.checkSourceInputAsDomainRoot(source))) {
			//start CR 6401898
                        //helpUsage();
                        getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
                        helpUsage();
                        //end CR 6401898
                        System.exit(1);
                    }
                }
                if(commonInfo.checkSourceInputAsDomainRoot(source))
                    commonInfo.setSourceDomainRoot(source);
                commonInfo.setSourceInstallDir(source);
                //commonInfo.enlistDomainsFromSource();
                inputMap.put(SOURCE,source);
                interactiveInput = true;
            }catch(Exception e) {
                getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if(inputMap.get(TARGET) == null && inputMap.get(TARGET_SHORT) == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_input"));
            byte b[] = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) { // input stream closed, maybe by ^C
                    System.exit(1);
                }
                String targetDir = new String(b,0,c);
                String target = targetDir.trim();
                File biDir = new File(target+File.separator+"bin");
                if (!UpgradeUtils.getUpgradeUtils(commonInfo).isValidTargetPath(target)) {
                    getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
                    helpUsage();
                    System.exit(1);
                }
                commonInfo.setTargetDomainRoot(target);
                commonInfo.enlistDomainsFromSource();
                inputMap.put(TARGET,target);
                interactiveInput = true;
            }catch(Exception e) {
                getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if(inputMap.get(ADMINUSER) == null && inputMap.get(ADMINUSER_SHORT) == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.adminuser_input"));
            byte b[] = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) { // input stream closed, maybe by ^C
                    System.exit(1);
                }
                String adminUser = new String(b,0,c);
                String admiuser = adminUser.trim();
                
                commonInfo.setAdminUserName(admiuser);
                inputMap.put(ADMINUSER,admiuser);
                interactiveInput = true;
            }catch(Exception e) {
                getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if(inputMap.get(ADMINPASSWORD) == null && inputMap.get(ADMINPASSWORD_SHORT) == null) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.adminpassword_input"));
            byte b[] = new byte[1024];
            try {
                String adminPassword =  new CliUtil().getPassword();
                commonInfo.setAdminPassword(adminPassword);
                inputMap.put(ADMINPASSWORD,adminPassword);
                interactiveInput = true;
                if(commonInfo.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE))
                    verifyUserAndPasswords(commonInfo.getAdminUserName(),commonInfo.getAdminPassword(),null);
            }catch(Exception e) {
                getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);            }
        }
        
        if(!commonInfo.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)){
            if(inputMap.get(MASTERPASSWORD) == null && inputMap.get(MASTERPASSWORD_SHORT) == null) {
                System.out.print(sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"));
                String password =  new CliUtil().getPassword();
                commonInfo.setMasterPassword(password);
                inputMap.put(MASTERPASSWORD, password);
                verifyUserAndPasswords(commonInfo.getAdminUserName(),commonInfo.getAdminPassword(),password);
                interactiveInput = true;
            }
        }
        
        if(inputMap.get(CLINSTANCEINFO) == null && inputMap.get(CLINSTANCEINFO_SHORT) == null && commonInfo.checkUpgradefrom7xeeto9xee()) {
            System.out.print(sm.getString("enterprise.tools.upgrade.cli.clinstance_input"));
            byte b[] = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) { // input stream closed, maybe by ^C
                    System.exit(1);
                }
                String clinstance = new String(b,0,c);
                String clinstancetrim = clinstance.trim();
                if (clinstancetrim.length() > 2) {
                    StringTokenizer st = new StringTokenizer(clinstancetrim,",");
                    Vector clinstanceList = new Vector();
                    while(st.hasMoreTokens()) {
                        clinstanceList.add(st.nextElement());
                    }
                    commonInfo.processClinstnceConfFiles(clinstanceList);
                }
                inputMap.put(CLINSTANCEINFO,clinstancetrim);
                interactiveInput = true;
            }catch(Exception e) {
                getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        
        if(commonInfo.isUpgradeJKStoJKS()) {
            if(inputMap.containsKey(JKSPWDFILE) || inputMap.containsKey(JKSPWDFILE_SHORT)) {
                if(inputMap.containsKey(CAPWDFILE) || inputMap.containsKey(CAPWDFILE_SHORT)) {
                    return;
                } else {
                    helpUsage();
                    System.exit(1);
                }
            }
        }
        if(commonInfo.isUpgradeJKStoNSS() || commonInfo.isUpgradeNSStoJKS()) {
            if(inputMap.containsKey(JKSPWDFILE) || inputMap.containsKey(JKSPWDFILE_SHORT)) {
                if(inputMap.containsKey(CAPWDFILE) || inputMap.containsKey(CAPWDFILE_SHORT)) {
                    if(inputMap.containsKey(NSSPWDFILE) || inputMap.containsKey(NSSPWDFILE_SHORT)) {
                        return;
                    } else {
                        helpUsage();
                        System.exit(1);
                    }
                }
            }
        }
        if(commonInfo.isUpgradeNSStoNSS()) {
            if(inputMap.containsKey(NSSPWDFILE) || inputMap.containsKey(NSSPWDFILE_SHORT)) {
                if(inputMap.containsKey(TARGETNSSPWDFILE) || inputMap.containsKey(TARGETNSSPWDFILE_SHORT)) {
                    return;
                } else {
                    helpUsage();
                    System.exit(1);
                }
            }
        }
        //certificate password collection starts here
        if (commonInfo.getSourceVersion().equals(UpgradeConstants.VERSION_7X)) {
            List stdAloneInsts = UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping());
            itr = stdAloneInsts.iterator();
        } else {
            domainList = commonInfo.getDomainList();
            itr =  domainList.iterator();
        }
        
        while(itr.hasNext()) {
            String domainName;
            String suffix;
            String certName;
            String certOption;
            String instanceName = null;
            if (commonInfo.getSourceVersion().equals(UpgradeConstants.VERSION_7X)) {
                Vector instDInfo = (Vector)itr.next();
                instanceName = (String)instDInfo.elementAt(0);
                DomainInfo dInfo = (DomainInfo)instDInfo.elementAt(1);
                domainName = dInfo.getDomainName();
                suffix = "-" + domainName;
                certName = domainName + ":" + instanceName;
                certOption = DOMAIN + "-" + certName;
            } else {
                domainName = (String)itr.next();
                suffix = "-" + domainName;
                certName = domainName;
                certOption = DOMAIN + suffix;
            }
            boolean certmigration = false;
            if(inputMap.get(certOption) == null) {
                String answer="no";
                while(true) {
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.Ask_domain_cert_migration", certName));
                    byte b[] = new byte[1024];
                    try {
                        int c = System.in.read(b);
                        if (c == -1) { // input stream closed, maybe by ^C
                            System.exit(1);
                        }
                        String ans = new String(b,0,c);
                        answer = ans.trim();
                        if(answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("y")
                        ||answer.equalsIgnoreCase("no") || answer.equalsIgnoreCase("n") || answer.equalsIgnoreCase(""))
                            break;
                    }catch(Exception e) {
                        getLogger().log(Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
                    }
                }
                if(answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("y")) {
                    if(!commonInfo.getDomainList().contains(domainName)){
                        helpUsage();
                        getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist",domainName));
                        System.exit(1);
                    }
                    commonInfo.setCurrentDomain(domainName);
                    commonInfo.addDomainOptionName(domainName);
                    inputMap.put(DOMAIN+"-"+commonInfo.getCurrentDomain(), domainName);
                    interactiveInput = true;
                    commonInfo.setCertificateConversionFlag(true);
                    certmigration = true;
                }
                
            } else {
                commonInfo.setCertificateConversionFlag(true);
                certmigration = true;
            }
            
            if((inputMap.get(NSSPWD+suffix) == null && certmigration) && (commonInfo.isUpgradeNSStoJKS() || commonInfo.isUpgradeJKStoNSS() || commonInfo.isUpgradeNSStoNSS()) ) {
                //String password = PasswordUtil.acceptPassword(sm.getString("enterprise.tools.upgrade.cli.NSS_input"));
                if(commonInfo.isUpgradeJKStoNSS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                else
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.NSS_pwd_input"));
                String password =  new CliUtil().getPassword();
                if(instanceName != null) {
                    commonInfo.setCertDbPassword(domainName,instanceName, password);
                } else {
                    commonInfo.setCertDbPassword(password);
                }
                
                boolean validpwd = PasswordVerifier.verifySourceNSSPassword(commonInfo);
                if(!validpwd) {
                    commonInfo.recover();
                    getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
                    System.exit(1);
                }
                inputMap.put(NSSPWD+"-"+domainName, password);
                interactiveInput = true;
            }
            if((inputMap.get(TARGETNSSPWD+suffix) == null && certmigration) && commonInfo.isUpgradeNSStoNSS() ) {
                //String password = PasswordUtil.acceptPassword(sm.getString("enterprise.tools.upgrade.cli.NSS_input"));
                System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                String password =  new CliUtil().getPassword();
                commonInfo.setTargetCertDbPassword(password);
                boolean validpwd = PasswordVerifier.verifyTargetNSSPassword(commonInfo,commonInfo.getTargetConfig());
                if(!validpwd) {
                    commonInfo.recover();
                    getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_target_nss_password"));
                    System.exit(1);
                }
                inputMap.put(TARGETNSSPWD+"-"+domainName, password);
                interactiveInput = true;
            }
            
            if((inputMap.get(JKSPWD+suffix) == null && certmigration) && ( commonInfo.isUpgradeJKStoJKS() || commonInfo.isUpgradeJKStoNSS() ||  commonInfo.isUpgradeNSStoJKS())) {
                //String password = PasswordUtil.acceptPassword(sm.getString("enterprise.tools.upgrade.cli.JKS_input"));
                if(commonInfo.isUpgradeNSStoJKS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_JKS_input"));
                if(commonInfo.isUpgradeJKStoNSS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.JKS_input"));
                if(commonInfo.isUpgradeJKStoJKS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.JKS_password"));
                String password =  new CliUtil().getPassword();
                commonInfo.setJksKeystorePassword(password);
                //String jksPath=commonInfo.getTargetJKSKeyStorePath();
                String jksPath="";
                if(commonInfo.isUpgradeNSStoJKS())
                    jksPath=commonInfo.getTargetJKSKeyStorePath();
                else
                    jksPath=commonInfo.getSourceJKSKeyStorePath();
                boolean validpwd = PasswordVerifier.verifyKeystorePassword(jksPath,password );
                if(!validpwd) {
                    commonInfo.recover();
                    getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                    System.exit(1);
                }
                inputMap.put(JKSPWD+"-"+domainName, password);
                interactiveInput = true;
            }
            
            if((inputMap.get(CAPWD+suffix) == null && certmigration) && ( commonInfo.isUpgradeJKStoJKS() || commonInfo.isUpgradeJKStoNSS() ||  commonInfo.isUpgradeNSStoJKS())) {
                //String password = PasswordUtil.acceptPassword(sm.getString("enterprise.tools.upgrade.cli.CA_input"));
                if(commonInfo.isUpgradeNSStoJKS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.Target_CA_input"));
                if(commonInfo.isUpgradeJKStoNSS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.CA_input"));
                if(commonInfo.isUpgradeJKStoJKS())
                    System.out.print(sm.getString("enterprise.tools.upgrade.cli.CA_password"));
                String password =  new CliUtil().getPassword();
                commonInfo.setJksCAKeystorePassword(password);
                //String jksPath=commonInfo.getTargetTrustedJKSKeyStorePath();
                String trustJksPath="";
                if(commonInfo.isUpgradeNSStoJKS())
                    trustJksPath = commonInfo.getTargetTrustedJKSKeyStorePath();
                else
                    trustJksPath = commonInfo.getSourceTrustedJKSKeyStorePath();
                boolean validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath,password );
                if(!validpwd) {
                    commonInfo.recover();
                    getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                    System.exit(1);
                }
                inputMap.put(CAPWD+"-"+domainName, password);
                interactiveInput = true;
            }
        }
    }
    
    private void verifyUserAndPasswords(String adminUser, String adminPassword, String masterPassword) {
        
        if(!UpgradeUtils.getUpgradeUtils(commonInfo).validateUserDetails(adminUser,adminPassword,masterPassword)) {
            if(!commonInfo.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)){
                getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
            } else {
                getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword"));
            }
            System.exit(1);
        }
        
    }
    
    public void verifyCommonInfo(CommonInfoModel commonInfo){
        if(commonInfo.getSourceInstallDir().equals(commonInfo.getTargetInstallDir())) {
            String msg = sm.getString("enterprise.tools.upgrade.cli.Invalid_input_directory");
            helpUsage(msg);
            System.exit(1);
        }
        if(!(interactiveInputMap.containsKey(SOURCE) || interactiveInputMap.containsKey(SOURCE_SHORT) &&
                interactiveInputMap.containsKey(TARGET) || interactiveInputMap.containsKey(TARGET_SHORT) &&
                interactiveInputMap.containsKey(ADMINUSER) || interactiveInputMap.containsKey(ADMINUSER_SHORT)&&
                interactiveInputMap.containsKey(ADMINPASSWORD) || interactiveInputMap.containsKey(ADMINPASSWORD_SHORT))){
            helpUsage();
            System.exit(1);
        }
    }

    
    public static void main(String[] args) throws Exception{
        CLIParser parser = new CLIParser();
        parser.setCommonInfoModel(new CommonInfoModel());
        parser.parseComandLineArguments(args);
        parser.printInfo();
    }
    
    private String readPassword(String pwdfile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pwdfile)));
            String password = reader.readLine();
            if(password != null)
                password = password.trim();
            else {
                getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.password_missing",pwdfile));
                System.exit(1);
            }
            return password;
        }catch(FileNotFoundException fe){
            helpUsage();
            getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.password_file_missing",pwdfile));
            System.exit(1);
        }catch(Exception io){
            getLogger().severe(sm.getString("enterprise.tools.upgrade.cli.password_missing",pwdfile));
            System.exit(1);
        }
        return null;
    }
}



