/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ClusteredInstance.java
 *
 * Created on May 21, 2004, 3:26 PM
 */

package com.sun.enterprise.tools.upgrade.cluster;

/**
 *
 * @author  prakash
 */

/*
 * This class represents one instance in clinstance.conf file
 *
 */ 

public class ClusteredInstance {
    
    private String instanceName;
    private String user;
    private String host;
    private String port;
    private String domain;
    private String instancePort;
    private boolean master;
    /** Creates a new instance of ClusteredInstance */
    public ClusteredInstance(String instName) {
        this.instanceName = instName;
    }
    public void extractDataFromLine(String line){
        if(line.trim().startsWith("user")){
            this.user = line.substring("user".length()).trim();
        }else if(line.trim().startsWith("host")){
            this.host = line.substring("host".length()).trim();
        }else if(line.trim().startsWith("port")){
            this.port = line.substring("port".length()).trim();
        }else if(line.trim().startsWith("domain")){
            this.domain = line.substring("domain".length()).trim();
        }else if(line.trim().startsWith("instanceport")){
            this.instancePort = line.substring("instanceport".length()).trim();
        }else if(line.trim().startsWith("master")){
            String masterStr = line.substring("master".length()).trim();
            this.master = ("true".equals(masterStr)) ? true :false; 
        }        
    }
    /** Getter for property port.
     * @return Value of property port.
     *
     */
    public java.lang.String getPort() {
        return port;
    }    
    
    /** Setter for property port.
     * @param port New value of property port.
     *
     */
    public void setPort(java.lang.String port) {
        this.port = port;
    }    

    /** Getter for property domain.
     * @return Value of property domain.
     *
     */
    public java.lang.String getDomain() {
        return domain;
    }    
    
    /** Setter for property domain.
     * @param domain New value of property domain.
     *
     */
    public void setDomain(java.lang.String domain) {
        this.domain = domain;
    }
    
    /** Getter for property host.
     * @return Value of property host.
     *
     */
    public java.lang.String getHost() {
        return host;
    }
    
    /** Setter for property host.
     * @param host New value of property host.
     *
     */
    public void setHost(java.lang.String host) {
        this.host = host;
    }
    
    /** Getter for property instanceName.
     * @return Value of property instanceName.
     *
     */
    public java.lang.String getInstanceName() {
        return instanceName;
    }
    
    /** Setter for property instanceName.
     * @param instanceName New value of property instanceName.
     *
     */
    public void setInstanceName(java.lang.String instanceName) {
        this.instanceName = instanceName;
    }
    
    /** Getter for property instancePort.
     * @return Value of property instancePort.
     *
     */
    public java.lang.String getInstancePort() {
        return instancePort;
    }
    
    /** Setter for property instancePort.
     * @param instancePort New value of property instancePort.
     *
     */
    public void setInstancePort(java.lang.String instancePort) {
        this.instancePort = instancePort;
    }
    
    /** Getter for property user.
     * @return Value of property user.
     *
     */
    public java.lang.String getUser() {
        return user;
    }
    
    /** Setter for property user.
     * @param user New value of property user.
     *
     */
    public void setUser(java.lang.String user) {
        this.user = user;
    }
    
    /** Getter for property master.
     * @return Value of property master.
     *
     */
    public boolean isMaster() {
        return master;
    }
    
    /** Setter for property master.
     * @param master New value of property master.
     *
     */
    public void setMaster(boolean master) {
        this.master = master;
    }
    
}
