/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import java.util.StringTokenizer;
import java.util.Vector;

/**
 *
 * @author Hans Hrasna
 */
public class ARG_clinstancefiles extends ArgumentHandler {
    
    /** Creates a new instance of ARG_clinstancefiles */
    public ARG_clinstancefiles(ParsedArgument pa) {
        super(pa);
        
        System.out.print(sm.getString("enterprise.tools.upgrade.cli.clinstance_input"));
        byte b[] = new byte[1024];
        try {
            int c = System.in.read(b);
            if (c == -1) { // input stream closed, maybe by ^C
                System.exit(1);
            }
            String clinstance = new String(b,0,c);
            String clinstancetrim = clinstance.trim();
            if (clinstancetrim.length() > 2) {
                StringTokenizer st = new StringTokenizer(clinstancetrim,",");
                Vector clinstanceList = new Vector();
                while(st.hasMoreTokens()) {
                    clinstanceList.add(st.nextElement());
                }
                commonInfo.processClinstnceConfFiles(clinstanceList);
            }
        }catch(Exception e) {
            _logger.log(java.util.logging.Level.SEVERE, sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
        }
    }
    
}
