/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * IIOPListener.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;

public class IIOPListener extends BaseElement {    
    private final String IIOP_LISTENER_PORT_PROPERTY_NAME="IIOP_LISTENER_PORT";
    
    public void transform(Element element, Element parentSource, Element parentResult){
        String elementTagName = element.getTagName();
        NodeList resultElements = parentResult.getElementsByTagName(elementTagName);
        Element resultElement = null;
        for(int lh =0; lh < resultElements.getLength(); lh++){
            Element itElement = ((Element)resultElements.item(lh));
            if((element.getAttribute("id")).equals(((Element)resultElements.item(lh)).getAttribute("id"))){
                resultElement = (Element)resultElements.item(lh);
                break;
            }
        }
        java.util.List notToTransferAttrList = this.getNonTransferList(element);            
        if(resultElement == null){
            resultElement = parentResult.getOwnerDocument().createElement(elementTagName);
            if(this.commonInfoModel.getCurrentCluster() != null){
                notToTransferAttrList.add("port");
                String propertyName = element.getAttribute("id")+"_IIOP_LISTENER_PORT";
                UpgradeUtils.getUpgradeUtils(this.commonInfoModel).updateListenerPortsForClusteredInstances(parentResult.getOwnerDocument().getDocumentElement(),
                                                                        propertyName, element.getAttribute("port"), this);
                resultElement.setAttribute("port", "${"+propertyName+"}");
            }
            this.transferAttributes(element, resultElement, notToTransferAttrList);
            this.appendElementToParent(parentResult,resultElement);  
        }else {            
            if(this.commonInfoModel.getCurrentCluster() == null){
                // This is for stand alone servers.  Lets not change the port nos. directly in config.  Rather set it in system property
                if(!this.commonInfoModel.getTargetEdition().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.EDITION_PE)){
                    String instanceName = this.commonInfoModel.getCurrentSourceInstance();
                    if((instanceName != null) &&(!("".equals(instanceName.trim())))){
                        if(element.getAttribute("id").equals("orb-listener-1")){
                            notToTransferAttrList.add("port");    
                            String propertyValue = element.getAttribute("port");
                            NodeList servers = parentResult.getOwnerDocument().getDocumentElement().getElementsByTagName("servers");
                            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
                            UpgradeUtils.getUpgradeUtils(this.commonInfoModel).addOrUpdateSystemPropertyToServer(instanceName, serverList, IIOP_LISTENER_PORT_PROPERTY_NAME, element.getAttribute("port"), this);
                        }
                    }
                }
            }
            this.transferAttributes(element, resultElement, notToTransferAttrList);
        } 
        super.transform(element,  parentSource, resultElement);  
    }
    
    protected void transferAttributes(Element source, Element result, java.util.List nonTransferList){
        //if(this.commonInfoModel.getCurrentCluster() == null){
            // For clusters it is handled in UpgradeUtils. So, only handle non clustered iiop-listeners here.
            if(!commonInfoModel.getTargetEdition().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.EDITION_PE)){
                if(commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X)){
                    if(source.getAttribute("id").equals("orb-listener-1") && source.getAttribute("port").equals("3700")){
                        // If server-config has 3700 as port no. for orb-listener-1 then, set it with the port no. that this listener has got.
                        // If switching is done, then it is ok to transfer the port 3700 from source to target.

                        String serverID = source.getOwnerDocument().getDocumentElement().getAttribute("name");
                        //result.getAttribute("port") may return ${IIOP_LISTENER_PORT}....need to check
                        // If the source is AS70 EE do not transfer the port. Do this only if the source is SE or 7.1EE
                        if(commonInfoModel.getSourceEdition().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.EDITION_SE) || 
                            this.isAppserver71EE(source)){
                            UpgradeUtils.getUpgradeUtils(this.commonInfoModel).switchedIIOPPorts(serverID,result.getAttribute("port"),result.getOwnerDocument().getDocumentElement());                    
                        }
                    }
                }
            }
        //}
        super.transferAttributes(source,result,nonTransferList);
    }
    protected java.util.List getNonTransferList(Element element){
        java.util.Vector notToTransferAttrList = new java.util.Vector();
        if(this.commonInfoModel.getCurrentCluster() != null){
            if(element.getAttribute("id").equals("orb-listener-1")){
                // In this case iiop-cluster processing transforms the port nos.  So, dont change the port no here.
                notToTransferAttrList.add("port");            
            }
        }        
        return notToTransferAttrList;
    }
    private boolean isAppserver71EE(Element source){
        Element docEle = source.getOwnerDocument().getDocumentElement();
        NodeList iiopClusters = docEle.getElementsByTagName("iiop-cluster");
        if((iiopClusters == null) || (iiopClusters.getLength() == 0)){
            return false;
        }
        return true;
    }
}
