/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/AliasMgrHashMapImpl.java,v 1.3 2005/12/25 03:45:43 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:43 $
 */
 

package com.sun.cli.jmx.support;

import java.util.Set;
import java.util.HashMap;
import java.util.Iterator;
import java.io.File;
import java.io.IOException;
import java.io.FileWriter;
import java.io.FileReader;

public final class AliasMgrHashMapImpl implements AliasMgrSPI
{
	final HashMap	mMap;
	String			mFilename;
	
	public final static String	DEFAULT_FILENAME	= "aliases.txt";
	
		public
	AliasMgrHashMapImpl()
	{
		mMap	= new HashMap();
	}
	
		public void
	create( String aliasName, String value ) throws Exception
	{
		mMap.put( aliasName, value );
		
		save();
	}
	
		public String
	get( String aliasName )
	{
		return( (String)mMap.get( aliasName ) );
	}
	
		public void
	delete( String aliasName )
		throws Exception
	{
		mMap.remove( aliasName );
		save();
	}
	
		public Set
	getNames()
	{
		return( mMap.keySet() );
	}
	
		public void
	save(  )
		throws IOException
	{
		if ( mFilename != null )
		{
			save( new File( mFilename ) );
		}
	}
	
		public void
	save( File theFile )
		throws IOException
	{
		mFilename	= theFile.getPath();
		
		final Set		names	= getNames();
		final Iterator	iter	= names.iterator();
		final String []	pairs	= new String [ names.size() ];
		
		for( int i = 0; i < pairs.length; ++i )
		{
			final String	name	= (String)iter.next();

			pairs[ i ]	= name + "=" + get( name );
		}
		
		final FileWriter	out	= new FileWriter( theFile );
		
		for( int i = 0; i < pairs.length; ++i )
		{
			out.write( pairs[ i ] + "\n" );
		}
		
		out.close();
	}
	
		private String
	readLine( FileReader in )
		throws IOException
	{
		StringBuffer	buf	= new StringBuffer();
		
		while ( true )
		{
			final int	i =in.read();
			if ( i < 0 )
			{
				return( null );
			}
		
			final char	theChar	= (char)i;
			if ( theChar == '\n' || theChar == '\r' )
			{
				// ignore blank lines
				if ( buf.length() == 0 )
					continue;
				break;
			}
			
			buf.append( theChar );
		}
		return( buf.toString() );
	}
	
		public void
	load( File theFile )
		throws Exception
	{
		mFilename	= theFile.getPath();
		
		final FileReader	in	= new FileReader( theFile );
		
		while ( true )
		{
			final String	pair	= readLine( in );
			if ( pair == null )
				break;
				
			final int		separatorOffset	= pair.indexOf( '=' );
			
			final String name	= pair.substring( 0, separatorOffset );
			final String value	= pair.substring( separatorOffset + 1, pair.length() );
			
			create( name, value );
		}
		
		in.close();
	}
};


