/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/StringifierRegistryIniter.java,v 1.3 2005/12/25 03:45:51 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:51 $
 */
 
package com.sun.cli.jmx.support;

import javax.management.*;
import javax.management.modelmbean.*;
import java.util.Iterator;
import java.util.Collection;

import com.sun.cli.jmx.support.ResultsForGetSetStringifier;
import com.sun.cli.util.stringifier.*;


/*
	Registers all included stringifiers with the default registry.
 */
public final class StringifierRegistryIniter
{
		private static void
	add( Class theClass, Stringifier theStringifier )
	{
		StringifierRegistry.DEFAULT.add( theClass, theStringifier );
	}
	
		public
	StringifierRegistryIniter(  )
	{
		add( Iterator.class, IteratorStringifier.DEFAULT );
		add( Collection.class, CollectionStringifier.DEFAULT );
		add( Object.class, SmartStringifier.DEFAULT );
		
		add( MBeanInfo.class, MBeanInfoStringifier.DEFAULT );
		add( ModelMBeanInfo.class, ModelMBeanInfoStringifier.DEFAULT );
		
		add( MBeanOperationInfo.class, MBeanOperationInfoStringifier.DEFAULT );
		add( ModelMBeanOperationInfo.class, ModelMBeanOperationInfoStringifier.DEFAULT );
		
		add( MBeanAttributeInfo.class, MBeanAttributeInfoStringifier.DEFAULT );
		add( ModelMBeanAttributeInfo.class, ModelMBeanAttributeInfoStringifier.DEFAULT );
		
		add( MBeanParameterInfo.class, MBeanParameterInfoStringifier.DEFAULT );
		
		add( MBeanNotificationInfo.class, MBeanNotificationInfoStringifier.DEFAULT );
		add( ModelMBeanNotificationInfo.class, ModelMBeanNotificationInfoStringifier.DEFAULT );
		
		add( MBeanConstructorInfo.class, MBeanConstructorInfoStringifier.DEFAULT );
		add( ModelMBeanConstructorInfo.class, ModelMBeanConstructorInfoStringifier.DEFAULT );
		
		add( Attribute.class, AttributeStringifier.DEFAULT );
		add( AttributeList.class, AttributeListStringifier.DEFAULT );
		
		add( Notification.class, NotificationStringifier.DEFAULT );
		add( AttributeChangeNotification.class, AttributeChangeNotificationStringifier.DEFAULT );
		add( MBeanServerNotification.class, MBeanServerNotificationStringifier.DEFAULT );
		
		add( ResultsForGetSet.class, new ResultsForGetSetStringifier( ) );
		add( InspectResult.class, new InspectResultStringifier( ) );
		add( InvokeResult.class, new InvokeResultStringifier( ) );
	}
	
}



