/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/MBeanOperationInfoStringifier.java,v 1.3 2005/12/25 03:46:05 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:05 $
 */
 

package com.sun.cli.util.stringifier;

import java.lang.reflect.Array;
import javax.management.*;

public class MBeanOperationInfoStringifier
	extends MBeanFeatureInfoStringifier implements Stringifier 
{
	public static MBeanOperationInfoStringifier	DEFAULT	= new MBeanOperationInfoStringifier(  );
	
		public
	MBeanOperationInfoStringifier(  )
	{
		super( );
	}
	
		public
	MBeanOperationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		super( options );
	}
	
		public String
	stringify( Object o )
	{
		assert( o != null );

		final MBeanOperationInfo	op	= (MBeanOperationInfo)o;
		
		String	result	= getPresentationTypeString( op.getReturnType() ) + " " + op.getName() + "(";
		
		// create the signature string
		result	= result + ParamsToString( op.getSignature(), mOptions) + ")";
					
		String impactStr	= "";
		switch( op.getImpact() )
		{
			default:								impactStr	= "unknown";	break;
			case MBeanOperationInfo.INFO:			impactStr	= "info";		break;
			case MBeanOperationInfo.ACTION:			impactStr	= "action";		break;
			case MBeanOperationInfo.ACTION_INFO:	impactStr	= "action-info";break;
		}
		
		result	= result + sOperationDelimiter + "impact=" +impactStr;
			
		if ( mOptions.mIncludeDescription )
		{
			result	= result + sOperationDelimiter + "\"" + op.getDescription() + "\"";
		}
		
		return( result );
	}
}