/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.admin.common.ObjectNames;

// jdk imports
import java.util.ArrayList;
import java.util.Iterator;

public class AddResourcesCommand extends GenericCommand{

    
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand()throws CommandException, CommandValidationException{
        if (!validateOptions())
            throw new CommandValidationException("Validation failed");
        
            String objectName = getObjectName();
            Object[] params = getParamsInfo();
            String operationName = getOperationName();
            String[] types = getTypesInfo();    
                        
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                    getUser(), getPassword());
        try { 
	     ArrayList returnValue =(ArrayList) mbsc.invoke(new ObjectName(objectName), 
					     operationName, params, types);
             Iterator iterator= returnValue.iterator();
             while (iterator.hasNext()){
                String resource = (String) iterator.next();
                CLILogger.getInstance().printMessage(" =========================");
                CLILogger.getInstance().printMessage(resource);
                
             }
	     CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }catch(Exception e){ 
	    if (e.getLocalizedMessage() != null)
		CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
						     new Object[] {name} ), e);
        }        
    }
        
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
}
