/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

//jdk 
import java.util.Iterator;
import java.io.Reader;
import java.io.Writer;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * The help command will display the help text for all the commands and their
 * options
 */
public class HelpCommand extends Command 
{

  private static final int DEFAULT_PAGE_LENGTH = 50;
  private static final int NO_PAGE_LENGTH = -1;
  private static final String DEFAULT_HELP_PAGE = "help";

        /** Creates new HelpCommand */
  public HelpCommand() 
  {
  }

        /**
         * override abstract method validateOptions()
         */
    public boolean validateOptions() throws CommandValidationException
    {
        return true;
    }
    
	  /**
	   * Executes the command
	   * @throws CommandException
	   */
  public void runCommand() throws CommandException, CommandValidationException 
  {

	try {
	  
	final More m = new More(getPageLength(),
							getSource(),
							getDestination(),
							getUserInput(),
							getUserOutput(),
							getQuitChar(),
							getPrompt());
	}
	catch (IOException ioe){
	  throw new CommandException(ioe);
	}
  }

  private String getCommandName(){
	return (operands.size() > 0
			? (String) getOperands().get(0)
			: DEFAULT_HELP_PAGE);
  }

  private Writer getDestination(){
	return new OutputStreamWriter(System.out);
  }

  private int getPageLength(){
      if ((getOption("isMultiMode")!=null &&
          getBooleanOption("isMultiMode")) &&
          (getOption("interactive")!=null &&
           getBooleanOption("interactive")) )
          return DEFAULT_PAGE_LENGTH;
      else
          return NO_PAGE_LENGTH;
  }

  private String getPrompt(){
      return getLocalizedString("ManpagePrompt");
  }
  
  private String getQuitChar(){
      return getLocalizedString("ManpageQuit");
  }

  private Reader getSource(){
	CLIManFileFinder c = new CLIManFileFinder();
	return c.getCommandManFile(getCommandName());
  }

  
  private Reader getUserInput(){
	return new InputStreamReader(System.in);
  }

  private Writer getUserOutput(){
	return new OutputStreamWriter(System.err);
  }

}
