/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.admin.common.ObjectNames;

// jdk imports
import java.io.File;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ListSecurityMapCommand extends GenericCommand{

    
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand()throws CommandException, CommandValidationException{
        if (!validateOptions())
            throw new CommandValidationException("Validation failed");
        
           String objectName = getObjectName();
            Object[] params = getParamsInfo();
            String operationName = getOperationName();
            String[] types = getTypesInfo();    
            String[] map = null;            
            String[] principals = null;
            String[] usergroups = null;
            
           MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                    getUser(), getPassword());
        try { 
	     ArrayList list  =(ArrayList)mbsc.invoke(new ObjectName(objectName), 
					     operationName, params, types);
             
             Iterator iterator= list.iterator();
             while (iterator.hasNext()){
                map = (String[]) iterator.next();
                    CLILogger.getInstance().printMessage(" ====================================");
                    CLILogger.getInstance().printMessage(" Security Map Name is :"  +map[0]);
                    CLILogger.getInstance().printMessage(" =====================================");
                    if(map[1] != null)
                        principals = getOptionsList(map[1]);
                    if(map[2] != null)    
                        usergroups = getOptionsList(map[2]);
                        
                    if(principals != null){ 
                        CLILogger.getInstance().printMessage("Principals for Security Map :"+  map[0] +"  are :");
                        for(int i = 0;i<principals.length;i++)
                            CLILogger.getInstance().printMessage("<principal>  "  +principals[i]);  
                    }
                   CLILogger.getInstance().printMessage("\n");
                   if(usergroups != null ){
                   CLILogger.getInstance().printMessage("UserGroups for Security Map :"+ map[0] +"  are :");
                        for(int i = 0;i<usergroups.length;i++)
                            CLILogger.getInstance().printMessage("<user-group>  "+usergroups[i]);  
                    }
                    CLILogger.getInstance().printMessage("\n");
                    if(map[3] != null){
                        String username = map[3];
                        CLILogger.getInstance().printMessage("Backend Principal User Name for :"+map[0] +"  is  :"+username);
                        CLILogger.getInstance().printMessage(" \n");
                    }
                    if(map[4] != null){
                        String password = map[4];
                        CLILogger.getInstance().printMessage("Backend Principal Password for :"+map[0] +"  is  :"+password);
                        CLILogger.getInstance().printMessage("\n");
                    }

                    
                    }     
                 
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
            					       new Object[] {name}));
        }catch(Exception e){ 
	    if (e.getLocalizedMessage() != null)
		CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
						     new Object[] {name} ), e);
        }        
    }
        
    private String[] getOptionsList(Object sOptions){
        StringTokenizer optionTokenizer   = new StringTokenizer((String)sOptions,",");
        int             size            = optionTokenizer.countTokens();
        String []       sOptionsList = new String[size];
        for (int ii=0; ii<size; ii++){
            sOptionsList[ii] = optionTokenizer.nextToken();
        } 
        return sOptionsList;
   }
    
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
}
