/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

/**
   This class gets called when create-security-map and update-security-map
   commands are invoked.
   This class will overwrite validOptions in GenericCommand to validate
   the mappedpassword option.  If the mappedpassword and passwordfile options
   are not entered in the command line and interactive is true, then
   CLI does not prompt the user for the password since this option is optional.
 */
public class SecurityMapCommand extends GenericCommand
{
    private static final String MAPPED_PASSWORD = "mappedpassword";
    
    protected String getOptionName() {
        return MAPPED_PASSWORD;
    }
    
    /**
       Validate the mappedpassword option.
     */    
    public boolean validateOptions() throws CommandValidationException
    {
    	super.validateOptions();
        
        try {String mappedPassword = getPassword(getOptionName(), true, false, false, false, null, null, false, false, false, true);
            setOption(getOptionName(), mappedPassword);
        }
        catch (CommandException ce) {
            throw new CommandValidationException(ce.getLocalizedMessage());
        }                
        
        return true;
    }

}
