/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

/**
 *  Whenever the HelpException is thrown, it will use the helpclass defined
 *  in the xml to display the usage text or manpage.
 * @author <a href="mailto:jane.young@sun.com">Jane Young</a>
 * @version $Revision: 1.3 $
 */
public class HelpException extends java.lang.Exception 
{
    private String command = null;
    private boolean isShell = false;

    /**
     * Creates new <code>HelpException</code> without detail message.
     */
    public HelpException() 
    {
    }

    /**
     * Creates new <code>HelpException</code> with the command name to display the help
     */
    public HelpException(String commandName) 
    {
        command = commandName;
    }

    public HelpException(String[] args) 
    {
        if (args.length<2) {
            command = null;
        }
        else {
                //help, help --shell, help command --shell
            int next = 1;
            if(!args[next].startsWith("--"))
                command = args[next++];
            if(args.length>next && args[next].equals("--shell"))
                isShell = true;
        }
    }

    /**
     *  Returns the help class to invoke.
     */
    public String getHelpClassName()
    {
        //read CLI descriptor
        final CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
	return cliDescriptorsReader.getHelpClass();
    }
    
    /**
     *  Returns the command to display the help.
     */
    public String getCommandName()
    {
        return command;
    }

    /**
     *  Returns the usage text of the command.
     */
    public String getUsageText()
    {
        try 
        {
                //read CLI descriptor
            final CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
                //get the validCommand object from CLI descriptor
            final ValidCommand validCommand = cliDescriptorsReader.getCommand(command);
            return validCommand.getUsageText();
        }
        catch (Exception e) 
        {
            return null;
        }
    }
    
    public boolean isShell(){
        return isShell;
    }
}


