/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin;

//JDK imports
import java.io.File;
import java.io.InputStream;
import java.net.URL;

//JMX imports
import javax.management.MBeanServer;
import javax.management.ObjectInstance;


/*
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.WebConfigChangeEventListener;
import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoringChannel;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.admin.common.constant.AdminConstants;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.Constants;

import com.iplanet.ias.server.ServerContext;
 */
import com.sun.appserv.server.ServerLifecycleException;

/*
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.ContactDataSet;
import com.iplanet.ias.admin.common.domains.registry.ContactData;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.HttpListener;
 */

import com.sun.enterprise.config.ConfigFactory;

import java.io.File;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;

/*
//Logging related imports
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;

//Utility methods
import com.iplanet.ias.util.io.FileUtils;

 */
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.config.ConfigMBeansManager;
import com.sun.enterprise.management.ManagementObjectManager;
import com.sun.enterprise.management.util.J2EEManagementObjectManager;


/**
 * Admin service is run every instance and acts as gateway to server
 * administration tasks.
 * 
 * NEW: Admin service determines if the running instance is
 * DAS or DASD or INSTANCE. Based on that it figures out
 * what to load.
 */
public class AdminService {

    /*
     * Flag to enable performance 
     */
    public static final boolean ENABLE_PERFORMANCE_THREAD = true;
    
    /** The logger from LogDomains */
    /* Note that this is the ONLY class that is dependent on the LogDomains.
     * Once registered through LogDomains, others can get it using standard
     * call Logger.getLogger() */
    
    /*
    //FIXME: removed for now.
    public static final Logger sLogger 
            = LogDomains.getLogger(AdminConstants.kLoggerName);
     */
    private static AdminService adminService = null;
    private static String adminType = null;
    private static final String DASD_TYPE = "DASD";
    private static final String DAS_TYPE = "DAS";
    private static final String INSTANCE_TYPE = "INSTANCE";

    private static String  kTempDirNamePrefix   = "s1astemp";
    private static String  kGUITempDirName      = "gui";
    /*
    private static String  kTempDirNameSuffix   = 
            "" + ((System.getProperty(Constants.IAS_ROOT) != null) ?
            System.getProperty(Constants.IAS_ROOT).hashCode() : 0);
     */
    
    /* The temporary directory name should be a function of domain name, 
     * admin-server id and the install root, otherwise it won't
     * work for the multiple installations on the same machine. */
    
    private static int          sMBeanServerID;
    public static final int     kDefaultImpl = 0;
    
    //private ServerContext context;
    
    private String mTempDirPath;
    private String mGUITempDirPath;

    /**
     * Package constructor. AdminService life cycle is managed through
     * LifeCycleManager object in this package.
     */
    AdminService() {
        sMBeanServerID = kDefaultImpl; //the only implementation for now
    }

    /**
     * set AdminService. This method should be called by LifeCycleManager
     * after instantiating the service. This enables other objects to use
     * static method getAdminService to get access to admin service.
     */
    static void setAdminService(AdminService srv) {
        adminService = srv;
    }

    /**
     * Get admin service object. Admin service is started when server starts
     * up.
     */
    public static AdminService getAdminService() {
        return adminService;
    }

    /**
     * Initialize admin service. This is called just after creating the
     * instance and before any public methods are called on admin service.
     * Initializes the admin server's MBeanServer.
     * Currently initializes the MBeanServer with default implementation in
     * com.iplanet.ias.admin.server.core.jmx.MBeanServerImpl.
     * Should there be multiple implementations, this method needs to be
     * modified.
     * @throws LifeCycleException in case the initialzation fails.
     */
    void init() throws ServerLifecycleException {
        /*
        MBeanServer mbs = null;

        
        if (sMBeanServerID == kDefaultImpl) {
            try {
                mbs = ASMBeanServerImpl.getMBeanServerInstance();
                MBeanServerFactory.initialize(this, mbs);
                if (isAdminInstance()) {
                    sLogger.log(Level.INFO, "core.mbs_init_ok");
                    createTimeStampFilesForInstances();
                    //background check for manualchanges
                    if(ENABLE_PERFORMANCE_THREAD) ManualChangeTracker.start();
                }
                else {
                    if (sLogger.isLoggable(Level.FINEST)) {
                        sLogger.log(Level.FINEST,"core.mbs_init_ok");
                    }
                }
                GenericMonitorMBean root = GenericMonitorMBean.getRoot();
                ObjectInstance oi = mbs.registerMBean(root, root.getObjectName());
                String oName = oi.getObjectName().toString();
                if (sLogger.isLoggable(Level.FINEST)) {
                    sLogger.log(Level.FINEST, "monitor.reg_root_mbean", oName);
                }
            }
            catch (Throwable t) {
                if (isAdminInstance()) {
                    sLogger.log(Level.SEVERE, "core.mbs_init_exception", t);
                }
                else {
                    sLogger.log(Level.WARNING, "core.mbs_init_exception", t);
                }
                throw new ServerLifecycleException(t.getMessage());
            }
        }
         */
        
        // These are common for all admin types. needs to happen on init.
        
        createConfigContext();
        createRegistry();
        createMBS();
        createAdminServiceMBean();
    }
    
    
    /**
     * Start admin service. This is called prior to any public method call
     * on admin service. This should be used to prepare admin service to
     * receive public method calls.
     */
    void start() throws ServerLifecycleException {
        if (isAdminInstance()) {
            startAdminInstance();
        } else {
            startNormalInstance();
        }
    }

    /**
     * Admin service is ready. All other services have started up successfully.
     */
    void ready() throws ServerLifecycleException {
        if (isAdminInstance()) {
            readyAdminInstance();
        } else {
            readyNormalInstance();
        }
    }

    /**
     * Stop admin service. This is called when shutdown process starts.
     */
    void stop() throws ServerLifecycleException {
        if (isAdminInstance()) {
            //stop checking for manual changes
            //if(ENABLE_PERFORMANCE_THREAD) ManualChangeTracker.stop();
            stopAdminInstance();
        } else {
            stopNormalInstance();
        }
    }

    /**
     * Destroy admin service. This is called just before JVM is destroyed.
     */
    void destroy() throws ServerLifecycleException {
    }

    /**
     * Get server context.
     * /
    public ServerContext getContext() {
        return ((adminService == null) ? null : adminService.context);
    }

    /**
     * Set context to specified value. Typically, lifecycle manager will call
     * this method during initialization to set appropriate context.
     * /
    void setContext(ServerContext ctx) {
        context = ctx;
    }

    /**
     * Get name of server instance.
     */
    public String getInstanceName() {
        return "PE";
        //FIXME: NYI
        //return ((context == null) ? null : context.getInstanceName());
    }

    /**
     * Get root monitoring MBean. Monitoring MBeans within a server instance
     * are organized in a tree. This object represents the root of the tree.
     * /
    public GenericMonitorMBean getRootMonitorMBean() {
        return GenericMonitorMBean.getRoot();
    }

    /**
     * Helper method to start admin server instance
     */
    private void startAdminInstance() throws ServerLifecycleException {
        //FIXME
       
        //setAdminInstanceProperties();
        
        //NEW: now we know we are either DASD or DAS
        
        // start some mbeans. no lazy loading for these mbeans
        registerAdminMBeans();
        
        if(DASD_TYPE.equals(adminType)) {
            //enable deployment. how?
        }
        
        //AdminChannel.createRMIChannel();
        //AdminChannel.createSharedSecret();
        
        // Test code here
        // new com.iplanet.ias.admin.event.EventTester();
        // Uncomment following line to test monitoring
        // new com.iplanet.ias.admin.monitor.MonitoringTester();
        
        //FIXME NYI
        //createTempDir();
    }

    /**
     * Helper method to perform necessary tasks when admin service is set as
     * ready.
     */
    private void readyAdminInstance() throws ServerLifecycleException {
        /*
        AdminChannel.setRMIChannelReady();
        updateDomainRegistry();
         */
    }

    /**
     * Helper method to stop admin server instance.
     */
    private void stopAdminInstance() throws ServerLifecycleException {
        /*
        deleteTempDir();
        AdminChannel.destroyRMIChannel();
         */
    }

    /**
     * Helper method to start normal (non-admin) instances
     */
    private void startNormalInstance() throws ServerLifecycleException {
        //AdminChannel.createRMIChannel();
        //AdminChannel.createSharedSecret();
        //AdminEventListenerRegistry.addMonitoringEventListener(
        //        new MonitoringChannel());
        //WebConfigChangeEventListener web = new WebConfigChangeEventListener();
        //AdminEventListenerRegistry.addConfigChangeEventListener(
        //        web.getConfigChangeCategory(), web);
        // Test code here
        // new com.iplanet.ias.admin.event.EventTester("str");
    }

    /**
     * Helper method to set normal instances to ready state.
     */
    private void readyNormalInstance() throws ServerLifecycleException {
        //AdminChannel.setRMIChannelReady();
    }

    /**
     * Helper method to stop normal (non-admin) instances
     */
    private void stopNormalInstance() throws ServerLifecycleException {
        //AdminChannel.destroyRMIChannel();
    }

    /**
     * Is this admin service running within admin server instance. Admin service
     * runs in all server instances.
     * @return true if the service is running in an admin server instance,
     *    false otherwise.
     */
    //FIXME: NYI
    public boolean isAdminInstance() {
        return true;
        /*
        if (ServerManager.ADMINSERVER_ID.equals(context.getInstanceName())) {
            return true;
        } else {
            return false;
        }
         */
    }
    
    /**
     Creates the time stamp files (if do not exist) for the instances that the
     admin server manages.    
    * /
    private void createTimeStampFilesForInstances() {
        String[] instanceIds = ServerManager.instance().getInstanceNames(true);
        for (int i = 0 ; i < instanceIds.length ; i ++) {
            try {
                String instanceId = instanceIds[i];
                InstanceEnvironment ie = new InstanceEnvironment(instanceId);
                ie.createTimeStampFiles();
		        sLogger.log(Level.INFO, "core.ts_files_ok", instanceId);
            }
            catch (Exception e) {
                //Log the exception for this instance, squelching is OK?
                sLogger.log(Level.WARNING, "core.ts_files_failed", e);
            }
        }
        
    }

    /**
        Gets the name of the temporary folder where the admin-server would be
        creating some temporary data. Note that this method is not a pure 
        accessor in the sense that it will create the folder on disk if
        it does not exist.
        @return String representing the absolute path of temporary folder, which
        may be null if the file creation fails.
    */
    public String getTempDirPath() {
        if (mTempDirPath == null) {
        /* Give it one more try, if on the startup the
           user does not have enough space and/or the temp
           file was not created. Note that the first-time failure will
           be detected in the log at startup.
           Also note that this additional safety does not come without
           the overhead of the null check for every call to this function.
       */
           // createTempDir();
        }
        
        return ( mTempDirPath );
    }

    /**
        Gets the name of the temporary folder where the admin-GUI would be
        creating some temporary data. Note that this method is not a pure 
        accessor in the sense that it will create the folder on disk if
        it does not exist.
        @return String representing the absolute path of temporary folder
        for GUI, which may be null if the file creation fails.
    */
    public String getGUITempDirPath() {
        if (mGUITempDirPath == null) {
        /* Give it one more try, if on the startup the
           user does not have enough space and/or the temp
           file was not created. Note that the first-time failure will
           be detected in the log at startup.
           Also note that this additional safety does not come without
           the overhead of the null check for every call to this function.
       */
           // createTempDir();
        }
        
        return ( mGUITempDirPath );
    }

    /*
    private void createTempDir() {
        try {
            String domainName       = ServerManager.instance().getDomainName();
	        String localTmpDir      = System.getProperty("java.io.tmpdir");
            String asTempDirName    = kTempDirNamePrefix + domainName + 
                    ServerManager.ADMINSERVER_ID + kTempDirNameSuffix;
     */
            /* for admin server, e.g. </tmp>/s1astempdomain1admin-server */
    /*
            File tempFolder     = new File(localTmpDir, asTempDirName);
            mTempDirPath        = tempFolder.getCanonicalPath();

     */
            /* for GUI, e.g. </tmp>/s1astempdomain1admin-server/gui*/
    /*
            File guiTempFolder  = new File(mTempDirPath, kGUITempDirName);
            mGUITempDirPath     = guiTempFolder.getCanonicalPath();
            if (tempFolder.exists()) {
     */
                /*
                    If it exists, the delete method during earlier admin-server
                    lifecycle was not able to delete the directory and
                    that should be OK. The intent here is to create a 
                    directory if there does not exist one.
                */
    /*
                sLogger.log(Level.FINEST, "core.tmp_folder_exists", 
                    mTempDirPath);
                return;
            }
     */
            /* try to create admin-server's temporary directory */
    /*
            boolean couldCreate = tempFolder.mkdirs();
            if (! couldCreate) {
                sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", 
                        mTempDirPath);
            }
            else {
                sLogger.log(Level.FINEST, "core.tmp_folder_created_ok", 
                    mTempDirPath);
            }
     */
            /* try to create temporary directory for GUI*/
    /*
            couldCreate = guiTempFolder.mkdirs();
            if (! couldCreate) {
                sLogger.log(Level.WARNING, "core.gui_tmp_folder_creation_failed", 
                        mGUITempDirPath);
            }
            else {
                sLogger.log(Level.FINEST, "core.gui_tmp_folder_created_ok", 
                    mGUITempDirPath);
            }
        }
        catch(Throwable t) {
            sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", t);
        }
    }

    private void deleteTempDir() {
        try {
            FileUtils.whack(new File(mTempDirPath));
            sLogger.log(Level.FINEST, "core.tmp_folder_deleted_ok", 
                mTempDirPath);
        }
        catch(Throwable t) {
            sLogger.log(Level.WARNING, "core.tmp_folder_deletion_failed", 
                    mTempDirPath);
        }
    }

     */
    
    /**
	 * Updates the Domain Registry with the Admin Server's listener
	 * information
	 * /
    private void updateDomainRegistry() {
		try{
			//get the DomainName of this admin server
			String domainName = ServerManager.instance().getDomainName();
			//get the DomainRegistryInstance
			DomainRegistry dreg = DomainRegistry.newInstance();
			//get the current Domain's entry in the registry
			DomainEntry de = dreg.getDomain(domainName);
			//get the DomainRoot
			File domainRoot = de.getRoot();
			//create a new ContactDataSet Object to hold
			//updated ContactData
			ContactDataSet cds = new ContactDataSet();

			//create the ContactDataSet Object
			Server s = (Server)context.getConfigBean();
			HttpListener[] listeners = (s.getHttpService()).getHttpListener();
			for(int i=0;i< listeners.length;i++){
			  HttpListener listener = listeners[i];
			  cds.add(new ContactData(listener.getServerName(),listener.getPort(),listener.isSecurityEnabled()));
			}
			//create the DomainEntry object for update
			DomainEntry domainEntry = new DomainEntry(domainName,domainRoot, cds);

			//Call Domain Registry.reregister
			   dreg.reregisterDomain(domainEntry);
		}
        catch(DomainRegistryException dre){
        	sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
        	sLogger.log(Level.FINE, "core.domain_exception_occured", dre);
        }
		catch(ConfigException ce){
			sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
			sLogger.log(Level.FINE, "core.config_exception_occured", ce);
		}
        catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
            sLogger.log(Level.FINE, "general.unexpected_exception", t);
        }
	}

    /**
     * Set system properties for admin server instance. Some of the admin code
     * relies on the property <code>com.sun.aas.javaRoot</code>. This method
     * will initialize the property using the value set by JVM plugin. If the
     * property is already set, it will not be changed.
     * /
    private void setAdminInstanceProperties() {
        try {
            String adminJavaRoot = System.getProperty(ADMIN_JAVAROOT);
            String pluginJavaRoot = System.getProperty(PLUGIN_JAVAROOT);
            if (adminJavaRoot == null) {
                if (pluginJavaRoot != null) {
                    System.setProperty(ADMIN_JAVAROOT, pluginJavaRoot);
                } else {
                    sLogger.log(Level.WARNING, "core.no_java_home");
                }
            }
        } catch (Throwable t) {
            sLogger.log(Level.WARNING, "core.set_admin_property_failed");
            sLogger.log(Level.FINE, "general.unexpected_exception", t);
        }
    }
    */
    
    /**
     * This method determines whether it is running as DAS or DASD or INSTANCE
     *
     * This has to be called after AdminServiceMBean has been initialized.
     *
     * @return "DAS" or "DASD" or "INSTANCE"
     */
    private static String getAdminType() {
       
        if(adminType != null) return adminType;
        
        //get Admin ServiceMBean
        
        //Determine the type of admin server
        adminType = "DAS"; //FIXME NYI
        //cache the value in adminType variable.
        return adminType;
    }
    

        /**
     * Create and configure the registry of managed objects.
     */
    private static void createRegistry() {
        System.out.println("Create configuration registry ...");
        try {
            URL url = AdminService.class.getResource
                ("/mbeans-descriptors.xml");
            InputStream stream = url.openStream();
            MBeanRegistry registry = new MBeanRegistry();
            registry.loadMBeanRegistry(stream);
            stream.close();
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }

    }

      /**
     * Create the tree of managed objects.
     */
    private void createConfigContext() {
        //FIXME: load from variables.
        try {
            //ConfigFactory.createConfigContext("/home/sridatta/jws/appserv-admin-core/dtds/domain.xml");
            ConfigFactory.createConfigContext("../config-api/dtds/domain.xml");
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }

    }

    //FIXME: load properties from outside
    //get domain name from somewhere.
     private void createMBS() {

        System.out.println("Creating MBeanServer ...");
        try {
            System.setProperty("javax.management.builder.initial", 
                    "com.sun.enterprise.admin.jmx.AppServerMBeanServerBuilder");
            
            //FIXME: we may want to cache MBS in a static variable since it needs to be accessed again.
            MBeanServer server = MBeanServerFactory.createMBeanServer("com.sun.appserv");
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }

    }

     private void createAdminServiceMBean() {

        System.out.println("Creating AdminServiceMBean ...");
        try {
            //load admin service mbean
            //nyi
            ;
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }

    }
  
     /**
      * This method is called when AdminType == DAS or DASD only
      */
     private void registerAdminMBeans() {
         //FIXME: keep reference to mom. or get it from switch. later.
         ConfigMBeansManager cmbm = new ConfigMBeansManager();
         ManagementObjectManager mom = new J2EEManagementObjectManager();
         
         //FIXME get domain name from admin service?
         String domain = "com.sun.appserv";
         mom.registerJ2EEDomain(domain);
         cmbm.registerAllConfigJ2EEServers();
     }
     
     //FIXME REMOVED
//    private static final String ADMIN_JAVAROOT = "com.sun.aas.javaRoot";
//    private static final String PLUGIN_JAVAROOT = "JAVA_HOME";
}
