/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.agent;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Iterator;

import javax.management.*;

/** 
 * The EventListenerProxy recieves notifications from RemoteListenerConnectors
 * registered on the server managed objects and forwards them to the corresponding
 * local listeners
 *
 * @author Hans Hrasna
 */
public class EventListenerProxy extends UnicastRemoteObject implements RemoteEventListener {
    private Hashtable listenerTable = new Hashtable();
    private Hashtable handbackTable = new Hashtable();
    private static String proxyAddress;
    private static EventListenerProxy eventProxy = null;
    private static int portnum=1100;
    private static String rmiName;
    private static boolean debug = false;

    public static EventListenerProxy getEventListenerProxy() {
		if(eventProxy == null) {
            try {
                eventProxy = new EventListenerProxy();
            	Naming.rebind(proxyAddress, eventProxy);
                if(debug) System.out.println(rmiName + " bound to existing registry at port " + portnum );

            } catch (RemoteException re) {
                if(debug) System.out.println("Naming.rebind("+ proxyAddress +", eventProxy): " + re);
                try {
                    eventProxy = new EventListenerProxy();
                    Registry r = LocateRegistry.createRegistry(portnum);
                    r.bind(rmiName, eventProxy);
                    if(debug) System.out.println(rmiName + " bound to newly created registry at port " + portnum );
                } catch(Exception e) {
                    eventProxy = null;
                    if(debug) e.printStackTrace();
                }
            } catch (Exception e) {
                if(debug) e.printStackTrace();
            }
        }
        return eventProxy;
    }

    public EventListenerProxy() throws java.rmi.RemoteException {
        String hostName;
        rmiName = "RemoteEventListener" + hashCode() + System.currentTimeMillis();
        try {
            hostName = java.net.InetAddress.getLocalHost().getHostAddress();
        } catch (java.net.UnknownHostException e) {
            hostName = "localhost";
            System.out.println(e);
        }
        proxyAddress = "//"+ hostName + ":" + portnum + "/" + rmiName;
    }

	public void handleNotification(Notification n, Object h) throws RemoteException {
        if (debug) System.out.println("EventListenerProxy:handleNotification(" + n + ")");
        NotificationListener listener = (NotificationListener)listenerTable.get((String)h);
        if (listener != null) {
            Object handback = handbackTable.get((String)h);
            listener.handleNotification(n,handback);
        } else {
            System.out.println("EventListenerProxy: listener id " + h + " not found");
        }
    }

    public String getProxyAddress() {
        return proxyAddress;
    }

    public void addListener(String id, NotificationListener l, Object handback) {
        if (debug) System.out.println("EventListenerProxy.addListener()");
        listenerTable.put(id, l);
        handbackTable.put(id, handback);
    }

    public void removeListener(String id) throws ListenerNotFoundException {
        if(listenerTable.remove(id) == null) {
            throw new ListenerNotFoundException();
        } else {
            handbackTable.remove(id);
        }
    }
}
