/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 

package com.sun.appserv.management.client;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

/**
	A source of an MBeanServerConnection.
	
	@see AppserverConnectionSource
	@see com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource
	@see com.sun.appserv.management.util.jmx.MBeanServerConnectionSource
 */
public interface ConnectionSource
{
	/**
		Return a valid MBeanServerConnection, making a new connection if necessary, or
		returning an existing one if still valid.  Some implementations may choose
		to not allow creation of a new connection (when 'forceNew' is specified).
		<p>
		Should not be called frequently, as the check for validity will make a remote
		call.
		<p>
		An implementation may choose to ignore the 'forceNew' parameter and always
		return the same connection.
		
		@param forceNew		creates a new connection instead of reusing an existing one
		@return the connection, or null if a new one is not possible
	 */
	public MBeanServerConnection	getMBeanServerConnection( boolean forceNew )
										throws IOException;
	
	/**
		@return existing connection, valid or not, may be null
	 */
	public MBeanServerConnection	getExistingMBeanServerConnection();
	
	/**
		@return a JMXConnector or null if not appropriate
	 */
	public JMXConnector		getJMXConnector( boolean forceNew )
								throws IOException;
}



