/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/DeployedItemRefConfigCR.java,v 1.7 2006/03/09 20:30:23 llc Exp $
 * $Revision: 1.7 $
 * $Date: 2006/03/09 20:30:23 $
 */
package com.sun.appserv.management.config;

import java.util.Map;


/**
	Represents the capability to create or remove ("CR") an instance of
	the &lt;application-ref&gt; element.
*/
public interface DeployedItemRefConfigCR extends ConfigRemover
{
	/** Key for use with createDeployedItemRefConfig() */
	public final static String	REF_KEY				= "Ref";
	/** Key for use with createDeployedItemRefConfig() */
	public final static String	ENABLED_KEY			= "Enabled";
	/** Key for use with createDeployedItemRefConfig() */
	public final static String	VIRTUAL_SERVERS_KEY		= "VirtualServers";
	
	public final static String	LB_ENABLED_KEY                  = "LBEnabled";

	public final static String	DISABLE_TIMEOUT_IN_MINUTES_KEY	= "DisableTimeoutInMinutes";


	/**
		Creates a new application-ref element.

		@param referencedApplicationName Application name.
		@param optional Map of optional aattributes whose keys are defined here.
		@return A proxy to the DeployedItemRefConfig MBean that manages the 
		config of newly created application-ref.
	 */
	public DeployedItemRefConfig createDeployedItemRefConfig(
		String referencedApplicationName, Map<String,String> optional);
        
	/**
		Creates a new application-ref element.

		@param enabled
		@param referencedApplicationName Application name.
		@param virtualServers	Comma separated list of virtual servers.
		@param lbEnabled
		@param disableTimeoutInMinutes
		@return A proxy to the DeployedItemRefConfig MBean that manages the 
		config of newly created application-ref.
	 */
	public DeployedItemRefConfig createDeployedItemRefConfig(boolean enabled, 
		String referencedApplicationName, String virtualServers,
		boolean lbEnabled, int disableTimeoutInMinutes);
        
	/**
		Creates a new application-ref element.

		@param referencedApplicationName Application name.
		@return A proxy to the DeployedItemRefConfig MBean that manages the 
		config of newly created application-ref.
	 */
	public DeployedItemRefConfig createDeployedItemRefConfig(String referencedApplicationName);
	
	/**
	 * Remove an existing &lt;application-ref&gt;
	 *
	 * @param referencedApplicationName the name of the application to remove
	 */
	public  void removeDeployedItemRefConfig( String referencedApplicationName );
}
