/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
* $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/HTTPProtocolConfig.java,v 1.3 2005/12/25 03:49:31 tcfujii Exp $
* $Revision: 1.3 $
* $Date: 2005/12/25 03:49:31 $
*/


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;

/**
Configuration for the &lt;http-protocol&gt; element.
*/

public interface HTTPProtocolConfig extends ConfigElement 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.HTTP_PROTOCOL_CONFIG;

	public String	getDefaultResponseType();
	/**
		Legal values include:
		<ul>
		<li>"text/html</li>
		<li>ISO-8859-1</li>
		<li>en</li>
		</ul>
	*/
	public void	setDefaultResponseType( final String value );

	public boolean	getDNSLookupEnabled();
	public void	setDNSLookupEnabled( final boolean value );

	/**
		@see HTTPProtocolConfigKeys#FORCED_RESPONSE_TYPE_KEY
	*/
	public String	getForcedResponseType();
	/**
		@see HTTPProtocolConfigKeys#FORCED_RESPONSE_TYPE_KEY
	*/
	public void	setForcedResponseType( final String value );

	public boolean	getSSLEnabled();
	public void	setSSLEnabled( final boolean value );

	public String	getVersion();
	public void	setVersion( final String value );

}
