/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/HealthCheckerConfigCR.java,v 1.6 2005/12/25 03:49:32 tcfujii Exp $
 * $Revision: 1.6 $
 * $Date: 2005/12/25 03:49:32 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

/**
    Supports creation and removal of health checker configurations.
*/
public interface HealthCheckerConfigCR {
    
    /**
      Creates a new health-checker.
      @param url 
          URL to ping so as to determine the health state of a
          listener. This must be a relative URL.
      @param intervalInSeconds     
          Interval, in seconds, between health checks. 
          A value of "0" means that the health check is 
          disabled. Default is 30 seconds. Must be 0 or greater.
      @param timeoutInSeconds      
          Maximum time, in seconds, that a server must 
          respond to a health check request to be considered 
          healthy. Default is 10 seconds. Must be greater than 0.
      @return A proxy to the HealthCheckerConfig MBean.
    */
    public HealthCheckerConfig createHealthCheckerConfig(String url, 
        String intervalInSeconds, String timeoutInSeconds);

    /**
      Removes a health checker config from the container config element
     */
    public void removeHealthCheckerConfig();
    
    /**
      @return A proxy to the HealthCheckerConfig MBean.
      Could be null because the HealthCheckerConfig may not be present.
     */
    public HealthCheckerConfig getHealthCheckerConfig();
}
