/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;



/**
    Mixin interface for access to library path.
 */
public interface Libraries
{
	/**
	    Optional Attribute (may be null).
	    <p>                                            
        These paths could be either relative [relative to                               
        {com.sun.aas.instanceRoot}/lib/applibs] or absolute paths.    
        These dependencies appears *after* the libraries defined in   
        classpath-prefix in the java-config and *before* the          
        application server provided over-rideable jar set. The        
        libraries would be made available to the application in the   
        order in which they were specified.
        
        @since AppServer 9.0   
	 */
	public String[] getLibraries();
	
	/**
	    Replaces the existing libraries Attribute. Certain
	    system applications may not allow changing this Attribute
	    (read only).
	                                            
        @see #getLibraries
        @since AppServer 9.0   
	 */
	public void setLibraries( String[] libraries );
}
