/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/LoadBalancerConfig.java,v 1.6 2005/12/25 03:49:43 tcfujii Exp $
 * $Revision: 1.6 $
 * $Date: 2005/12/25 03:49:43 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

import static com.sun.appserv.management.base.XTypes.*;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.monitor.Monitoring;

/**
   Configuration for the load-balancer element.
   
   @see com.sun.appserv.management.ext.lb.LoadBalancer for the runtime 
   counterpart of this config MBean
 */
public interface LoadBalancerConfig extends AMXConfig, PropertiesAccess, NamedConfigElement {

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE = LOAD_BALANCER_CONFIG;

    public static final String  DEVICE_HOST_PROPERTY         = "device-host";
    public static final String  DEVICE_ADMIN_PORT_PROPERTY   = "device-admin-port";
    public static final String  SSL_PROXY_HOST_PROPERTY      = "ssl-proxy-host";
    public static final String  SSL_PROXY_PORT_PROPERTY      = "ssl-proxy-port";
    
    /**
      Return the name of the lb-config-name used by this load-balancer
     */
    public String getLbConfigName();
    
    /**
      Return the boolean flag which indicates whether the changes to lb config 
      will be pushed or not.
     */
    public boolean getAutoApplyEnabled();

    /**
      Set the boolean flag to indicate whether the changes to lb config 
      will be pushed or not i.e. if true, changes will be pushed immediately
     */
    public void	setAutoApplyEnabled(final boolean value);
}
