/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

/**
	Keys for use with {@link DomainConfig#createStandaloneServerConfig} and 
	{@link DomainConfig#createClusteredServerConfig}
 */
public final class ServerConfigKeys
{
	private	ServerConfigKeys()	{}
	
    /** Key for the system property that would be used to assign port value for the listener named http-listener-1**/
        public static final String  HTTP_LISTENER_1_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"HTTP_LISTENER_PORT";
        
    /** Key for the system property that would be used to assign port value for the listener named http-listener-2**/
        public static final String  HTTP_LISTENER_2_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"HTTP_SSL_LISTENER_PORT";
        
    /** Key for the system property that would be used to assign port value for the iiop listener named orb-listener-1**/
        public static final String  ORB_LISTENER_1_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"IIOP_LISTENER_PORT";
        
    /** Key for the system property that would be used to assign port value for the iiop listener named admin-listener-port **/
        public static final String  ADMIN_LISTENER_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"HTTP_ADMIN_LISTENER_PORT";
        
    /** Key for the system property that would be used to assign port value for the secure iiop listener named SSL**/
        public static final String  SSL_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"IIOP_SSL_LISTENER_PORT";
        
    /** Key for the system property that would be used to assign port value for the secure client-auth
     * supporting SSL enabled iiop listenerlistener named SSL_MUTUALAUTH**/
        public static final String  SSL_MUTUALAUTH_PORT_KEY = PropertiesAccess.PROPERTY_PREFIX +"IIOP_SSL_MUTUALAUTH_PORT";
        
    /** Key for the system property that would be used to assign port value for the secure iiop listener named JMX_SYSTEM_CONNECTOR**/
        public static final String  JMX_SYSTEM_CONNECTOR_PORT_KEY= PropertiesAccess.PROPERTY_PREFIX +"JMX_SYSTEM_CONNECTOR_PORT";
        
    /** Key for the system property that would be used to assign port value for the secure iiop listener named JMX_SYSTEM_CONNECTOR**/
        public static final String  JMS_PROVIDER_PORT_KEY   = PropertiesAccess.PROPERTY_PREFIX +"JMS_PROVIDER_PORT";
}
