/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/helper/DeployedItemHelper.java,v 1.3 2005/12/25 03:50:36 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:50:36 $
 */
package com.sun.appserv.management.helper;

import java.util.Set;
import java.util.HashSet;

import javax.management.ObjectName;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.QueryMgr;

/**
	Helper for deployed items (modules).
 */
public final class DeployedItemHelper extends Helper
{
		public
	DeployedItemHelper( final DomainRoot	domainRoot )
	{
		super( domainRoot );
	}

	/**
		Get the ObjectNames of all deployed items in the specified server.
		To extract the names, use {@link Util}.getNamesSet(set).
		
		@param standaloneServerName
		@return Set of ObjectName for all modules
	 */
		public Set<ObjectName>
	queryStandaloneServerDeployedItemObjectNames(
		final String	standaloneServerName  )
	{
		// specify all STANDALONE_SERVER_DEPLOYED_ITEM_REF_CONFIG
		final String	refsProp	=
			Util.makeJ2EETypeProp( XTypes.DEPLOYED_ITEM_REF_CONFIG );
			
		// specify the server
		final String	serverProp	=
			Util.makeProp( XTypes.STANDALONE_SERVER_CONFIG, standaloneServerName );
			
		return( Util.toObjectNames( propsQuery( refsProp, serverProp ) ) );
	}
	
	/**
		Get the ObjectNames of all deployed items in the specified cluster.
		To extract the names, use {@link Util}.getNamesSet(set).
		
		@param clusterName
		@return Set of ObjectName for all modules
	 */
		public Set<ObjectName>
	queryClusterDeployedItemObjectNames(
		final String	clusterName  )
	{
		// specify all STANDALONE_SERVER_DEPLOYED_ITEM_REF_CONFIG
		final String	refsProp	= 
			Util.makeJ2EETypeProp( XTypes.DEPLOYED_ITEM_REF_CONFIG );
			
		// specify the server
		final String	clusterProp	=
			Util.makeProp( XTypes.CLUSTER_CONFIG, clusterName );
			
		return( Util.toObjectNames( propsQuery( refsProp, clusterProp ) ) );
	}
}


