/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/BoundaryStatisticImpl.java,v 1.4 2006/03/09 20:30:28 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:28 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;
import javax.management.j2ee.statistics.BoundaryStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

/**
	Serializable implementation of a BoundaryStatistic
 */
public class BoundaryStatisticImpl extends StatisticImpl
	implements BoundaryStatistic, Serializable
{
	static final long serialVersionUID = -5190567251179453418L;
	
	private long	LowerBound;
	private long	UpperBound;
	
	
		public
	BoundaryStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		lower,
		final long		upper )
	{
		super( name, description, unit, startTime, lastSampleTime );
		
		if ( LowerBound > UpperBound )
		{
			throw new IllegalArgumentException();
		}
		
		LowerBound	= lower;
		UpperBound	= upper;
	}
	
	/**
		Base the Statistic on the {@link CompositeData}
	 */
		public
	BoundaryStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	BoundaryStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
	
		public
	BoundaryStatisticImpl( final MapStatistic s )
	{
		super( s );
		
		LowerBound	= s.getlong( "LowerBound" );
		UpperBound	= s.getlong( "UpperBound" );
	}
	
		public
	BoundaryStatisticImpl( final BoundaryStatistic s )
	{
		super( s );
		
		LowerBound	= s.getLowerBound();
		UpperBound	= s.getUpperBound();
	}
	
		public long
	getLowerBound()
	{
		return( LowerBound );
	}
	
		public long
	getUpperBound()
	{
		return( UpperBound );
	}
}





