/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.util.jmx;

import javax.management.MBeanOperationInfo;

import com.sun.appserv.management.util.jmx.stringifier.MBeanOperationInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanFeatureInfoStringifierOptions;


/**
	Caution: this Comparator may be inconsistent with equals() because it ignores the description.
 */
public final class MBeanOperationInfoComparator
    implements java.util.Comparator<MBeanOperationInfo>
{
	private static final MBeanOperationInfoStringifier		OPERATION_INFO_STRINGIFIER	=
		new MBeanOperationInfoStringifier( new MBeanFeatureInfoStringifierOptions( false, ",") );
		
		
	public static final MBeanOperationInfoComparator
	    INSTANCE	= new MBeanOperationInfoComparator();
	
	private	MBeanOperationInfoComparator()	{}
	
		public int
	compare( final MBeanOperationInfo info1, final MBeanOperationInfo info2 )
	{
		final MBeanOperationInfoStringifier	sf	= OPERATION_INFO_STRINGIFIER;
		
		// we just want to sort based on name and signature; there can't be two operations with the
		// same name and same signature, so as long as we include the name and signature the
		// sorting will always be consistent.
		int	c	= info1.getName().compareTo( info2.getName() );
		if ( c == 0 )
		{
			// names the same, subsort on signature, first by number of params
			c	= info1.getSignature().length - info2.getSignature().length;
			if ( c == 0 )
			{
				// names the same, subsort on signature, first by number of params
				c	= sf.getSignature( info1 ).compareTo( sf.getSignature( info2 ) );
			}
			
		}
		
		return( c );
	}
	
		public boolean
	equals( Object other )
	{
		return( other instanceof MBeanOperationInfoComparator );
	}
}




