/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import java.util.Set;
import java.util.List;
import java.util.Iterator;

import javax.management.openmbean.TabularData;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularType;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;


public class TabularDataStringifier implements Stringifier
{
	public static final TabularDataStringifier	DEFAULT	= new TabularDataStringifier();
	
		public
	TabularDataStringifier( )
	{
	}
	
		public String
	stringify( Object o )
	{
		final StringBuffer	buf	= new StringBuffer();
		buf.append( "Tabular data:\n" );
		
		final TabularData	data	= (TabularData)o;
		final TabularType	type	= data.getTabularType();
		
		final List		indexNames	= type.getIndexNames();
		final Set		rowKeys		= data.keySet();
		final Iterator	rowIter	= rowKeys.iterator();
		int				rowIndex	= 0;
		while ( rowIter.hasNext() )
		{
			final Object[]		key		= (Object[])rowIter.next();
			final CompositeData	item	= data.get( key );
			
			final String	s	= SmartStringifier.toString( item );
			
			// emit the row index followed by the row
			buf.append( "[" + rowIndex + "] " );
			buf.append( s + "\n" );
			
			++rowIndex;
		}
		
		return( buf.toString() );
	}
}



















