/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/enterprise/management/deploy/DeploymentCallback.java,v 1.5 2005/12/25 03:52:03 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:52:03 $
 */
package com.sun.enterprise.management.deploy;

import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentProgress;

/**
	Intended for implementing code to make note of the relevant
	deployment events.
 */
public interface DeploymentCallback
{
	/**
		Deployment has finished.  This callback should only be made once when
		the deployment has finished.
	 */
	public void	deploymentDone( DeploymentStatus finalStatus );
	
	/**
		New progress information is available.  This callback may be called
		an arbitrary number of times, but may not be called after deploymentDone()
		has been called.
	 */
	public void	deploymentProgress( DeploymentProgress progress );
}

