/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * StatisticToString.java
 * $Id: StatisticToString.java,v 1.2 2005/12/25 03:52:33 tcfujii Exp $
 * $Date: 2005/12/25 03:52:33 $
 * $Revision: 1.2 $
 */


package com.sun.enterprise.admin.monitor.util;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

/**
 * Provides for String representation of all the Statistic classes.
 * @author  <a href="mailto:Kedar.Mhaswade@sun.com">Kedar Mhaswade</a>
 * @since S1AS8.0
 * @version $Revision: 1.2 $
 */
final class StatisticToString {
	
	private final Statistic stc;
	private final String SEP = ":";
	/** Creates a new instance of StatisticToString for given Statistic. Instances of
	 * this class are immutable. Note that the returned Strings are basically for debug
	 * purposes and should be displayed taking that into account.
	 * @param	c	Statistic instance that needs its string representation from this class
	 */
	StatisticToString(Statistic stc) {
		this.stc = stc;
	}
	
	/**
	 */
	public String toString() {
		final StringBuffer s = new StringBuffer();
		return ( s.append(baseString()).append(SEP).append(specificString()).toString() );
	}
	
	private String baseString() {
		final StringBuffer s = new StringBuffer();
		s.append(stc.getName()).append(SEP).append(stc.getUnit()).append(SEP).
		append(stc.getDescription()).append(stc.getStartTime()).append(stc.getStartTime());
		return (s.toString());
	}
	private String specificString() {
		final StringBuffer s = new StringBuffer();
		if (stc instanceof CountStatistic)
			s.append(countStatisticSpecificString());
		if (stc instanceof RangeStatistic)
			s.append(rangeStatisticSpecificString());
		if (stc instanceof BoundedRangeStatistic)
			s.append(boundedRangeStatisticSpecificString());
		if (stc instanceof TimeStatistic)
			s.append(timeStatisticSpecificString());
		return ( s.toString() );
	}
	private String countStatisticSpecificString() {
		final StringBuffer s = new StringBuffer();
		final CountStatistic cs = (CountStatistic)stc;
		return ( s.append(cs.getCount()).toString() );
	}
	private String rangeStatisticSpecificString() {
		final StringBuffer s = new StringBuffer();
		final RangeStatistic rs = (RangeStatistic)stc;
		return ( s.append(rs.getLowWaterMark()).append(SEP).append(rs.getHighWaterMark()).toString() );
	}
	private String boundedRangeStatisticSpecificString() {
		final StringBuffer s = new StringBuffer();
		final BoundedRangeStatistic bs = (BoundedRangeStatistic)stc;
		return ( s.append(bs.getUpperBound()).append(SEP).append(bs.getLowerBound()).toString() );
	}
	private String timeStatisticSpecificString() {
		final StringBuffer s = new StringBuffer();
		final TimeStatistic ts = (TimeStatistic)stc;
		return ( s.append(ts.getMaxTime()).append(SEP).append(ts.getMinTime()).append(SEP).append(ts.getTotalTime()).toString() );
	}
}
