/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: QuotedStringTokenizer.java,v 1.3 2006/03/16 21:25:38 kravtch Exp $
 */

package com.sun.enterprise.admin.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer
{
    private final char[] ca;
    private String delimiters = "\t ";
    private final int numTokens;
    private int curToken = 0;
    private final CharIterator iterator;

    public QuotedStringTokenizer(String s)
    {
        this(s, null);
    }

    public QuotedStringTokenizer(String s, String delim)
    {
        if (null == s)
        {
            throw new IllegalArgumentException("null param");
        }
        ca = s.toCharArray();
        if (delim != null && delim.length() > 0)
        {
            delimiters = delim;
        }
        numTokens = _countTokens();
        iterator = new CharIterator(ca);
    }
    
    public int countTokens()
    {
        return numTokens;
    }

    public boolean hasMoreTokens()
    {
        return curToken < numTokens;
    }

    public String nextToken()
    {
        if (curToken == numTokens)
            throw new NoSuchElementException();
        final StringBuffer sb = new StringBuffer();
        boolean bQuote = false;
        boolean bEscaped = false;
        char c;
        while ((c = iterator.next()) != CharIterator.EOF)
        {
            boolean isDelimiter = isDelimiter(c);
            if (!isDelimiter && !bEscaped)
            {
                sb.append(c);
                if (c == '\"')
                    bQuote = !bQuote;
                char next = iterator.peekNext();
                if (next == CharIterator.EOF || (isDelimiter(next) && !bQuote))
                    break;
            }
            else if (bQuote || bEscaped)
            {
                sb.append(c);
            }
            if(c=='\\')
                bEscaped = !bEscaped;
            else
                bEscaped = false;
        }
        curToken++;
        return sb.toString();
    }

    boolean isDelimiter(char c)
    {
        return delimiters.indexOf(c) >= 0;
    }

    private int _countTokens()
    {
        int     tokens = 0;
        boolean bQuote = false;
        boolean bEscaped = false;
        final   CharIterator it = new CharIterator(ca);
        char    c;

        while ((c = it.next()) != CharIterator.EOF)
        {
            char next = it.peekNext();
            if (!isDelimiter(c) && !bEscaped)
            {
                if (c == '\"')
                    bQuote = !bQuote;
                if (next == CharIterator.EOF || (isDelimiter(next) && !bQuote))
                    tokens++;
            }
            else if (next == CharIterator.EOF && bQuote) //eg :- "\" "
                tokens++;
            if(c=='\\')
                bEscaped = !bEscaped;
            else
                bEscaped = false;
        }
        return tokens;
    }

    private static final class CharIterator
    {
        static final char EOF = '\uFFFF';

        private final char[] carr;
        private int index = 0;

        private CharIterator(char[] ca)
        {
            carr = ca;
        }

        char next()
        {
            if (index >= carr.length)
                return EOF;
            char c = carr[index];
            ++index;
            return c;
        }

        char peekNext()
        {
            if (index >= carr.length)
                return EOF;
            return carr[index];
        }
    }
}
