/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.util.proxy;

import java.lang.reflect.Method;

/**
 * Represents a method call (or invocation)
 */
public class Call {

    private Method method;
    private Object[] arguments;
    private CallState callState = CallState.IN_PROCESS;
    private Throwable failureReason;
    private Object result;
    
    public Call(Method m, Object[] args) {
        method = m;
        arguments = args;
    }

    public Method getMethod() {
        return method;
    }

    public Object[] getArguments() {
        return arguments;
    }

    public CallState getState() {
        return callState;
    }

    public void setState(CallState state) {
        callState = state;
    }

    public Object getResult() {
        return result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Throwable getFailureReason() {
        return failureReason;
    }

    public void setFailureReason(Throwable reason) {
        failureReason = reason;
    }
}
