/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConfigProperties.java
 *
 * Created on January 13, 2004, 12:05 PM
 */

package com.sun.enterprise.tools.admingui;

import java.util.Hashtable;
import java.util.ResourceBundle;
import java.lang.reflect.Method;

public class ConfigProperties extends Hashtable{
    
    public static ConfigProperties getInstance() {
        return _instance;
    }
    
    public void setViewXMLFileName(String viewXMLFile) {
        put(VIEW_XML_FILE, viewXMLFile);
    }
    
    public void setTreeXMLFileName(String treeXMLFile, String treeType) {
        put(TREE_XML_FILE+treeType, treeXMLFile);
    }
    
    public String getViewXMLFileName() {
        return (String)(get(VIEW_XML_FILE));
    }
    
    public String getTreeXMLFileName(String treeType) {
        return (String)(get(TREE_XML_FILE+treeType));
    }

    public void setDefaultDisplayURLDir(String defaultDisplayURLDir) {
        put(DEFAULT_DISPLAY_URL_DIR, defaultDisplayURLDir);
    }
    
    public String getDefaultDisplayURLDir() {
        return (String)(get(DEFAULT_DISPLAY_URL_DIR));
    }
    
    public void setLoggerName(String loggerName) {
        put(LOGGER_NAME, loggerName);
    }
    
    public String getLoggerName() {
        return (String)(get(LOGGER_NAME));
    }
    
    public void setInitialRightPage(String page) {
        put(INITIAL_RIGHT_PAGE, page);
    }
    
    public String getInitialRightPage() {
        return (String)(get(INITIAL_RIGHT_PAGE));
    }
    
    public void setConsoleTitleKey(String consoleTitleKey) {
        put(CONSOLE_TITLE_KEY, consoleTitleKey);
    }
    
    public String getConsoleTitleKey() {
        return (String)(get(CONSOLE_TITLE_KEY));
    }
    
    public String getConsoleTitle() {
        ResourceBundle bundle = 
            ResourceBundle.getBundle("com.sun.enterprise.tools.admingui.resources.Resources");
        try {
            return bundle.getString((String)get(CONSOLE_TITLE_KEY));
        } catch (Exception ex) {
            return (String)get(CONSOLE_TITLE_KEY);
        }
    }
    
    public void setTargetSupported(Boolean targetSupported) {
        put(TARGET_SUPPORTED, targetSupported);
    }
    
    public Boolean getTargetSupported() {
        return (Boolean)(get(TARGET_SUPPORTED));
    }
    
    public String getDefaultTarget() {
        return (String)(get(DEFAULT_TARGET));
    }
    
    public void setDefaultTarget(String defaultTarget) {
        put(DEFAULT_TARGET, defaultTarget);
    }
    
    static public boolean isHCIAdmin22() {
 	try {
            Class clazz = Class.forName("com.sun.web.ui.common.CCSystem");
	    Method method = clazz.getMethod("getServerInterface", (Class[])null);
            if (method == null)
                return false;
	} catch (Exception e) {
	    return false;
	}
        return true;
    }

    private static ConfigProperties _instance =	new ConfigProperties();
    
    private static final String VIEW_XML_FILE       = "ViewXMLFile";
    private static final String TREE_XML_FILE       = "TreeXMLFile";
    private static final String DEFAULT_DISPLAY_URL_DIR = "DefaultDisplayURLDir";
    private static final String LOGGER_NAME         = "LoggerName";
    private static final String INITIAL_RIGHT_PAGE  = "InitialRightPage";
    private static final String TARGET_SUPPORTED    = "Target";
    private static final String CONSOLE_TITLE_KEY   = "ConsoleTitleKey";
    private static final String DEFAULT_TARGET      = "DefaultTarget";
    
}
