/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.model;

import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;

import java.util.HashMap;
import java.util.Map;


/**
 *  The purpose of this class is to extend the JATO model manager and add the
 *  ability to register a user-instantiated model in the Manager.  This is
 *  necessary because Lockhart models do not provide a means of creating some
 *  of their models via the default constructor (which is a requirement of the
 *  JATO ModelManager).
 */
public class ModelManager extends com.iplanet.jato.ModelManager {

    /**
     * 
     *
     * @param	requestContext
     *		The request context of the current request
     *
     * @param	typeMap
     *		An application-specific map that associates <code>Model</code> 
     *		interfaces with corresponding <code>Model</code> implementation 
     *		classes.
     */
    public ModelManager(RequestContext requestContext, ModelTypeMap typeMap) {
	super(requestContext, typeMap);
    }


    /**
     *	This method overrides the superclass method in order to check a local
     *	Map of instances first and to capture the created model instance if a
     *	local one is not found.  The reason we have to do it this way is
     *	because JATO did not provide access to the their Map of instances.
     */
    public Model getModel(Class cls, String name, boolean lookInSession, boolean storeInSession) {
    	// Check the instance Map
	Model model = (Model)getInstanceMap().get(name);
	if (model != null) {
	    return model;
	}

	// Not cached, get new...
	model = super.getModel(cls, name, lookInSession, storeInSession);

	// Save for next time...
	if (model != null) {
	    if (model instanceof DefaultModel) {
	    	// Screws up model.clear() if set to true
		((DefaultModel)model).setUseDefaultValues(false);
	    }
	    getInstanceMap().put(name, model);
	}

	// Return the model.
	return model;
    }


    /**
     *	This is a new method, and the purpose of writing this class.  This
     *	method allows Models created elsewhere to be registered here.  This
     *	will allow ModelManager.getModel(...) to return us our model (yea!).
     *	This was needed because Lockhart does not allow their models to be
     *	created via the default constructor making them incompatible with
     *	JATO's ModelManager.
     *
     *	@param	name	The instance name this instance of the model should be
     *			known by.
     *	@param	model	The model instance.
     */
    public void registerModel(String name, Model model) {
    	if (name == null) {
	    throw new IllegalArgumentException(
		"You cannot register a Model with a (null) name!");
	}
	getInstanceMap().put(name, model);
    }


    /**
     *	While we're at it, might as well provide a contains method...
     */
    public boolean contains(String name) {
	return getInstanceMap().containsKey(name);
    }


    /**
     *	This method returns the Map of instances.
     */
    protected Map getInstanceMap() {
	return _instanceMap;
    }


    /**
     *	This method sets the Map of instances.
     */
    protected void setInstanceMap(Map map) {
	_instanceMap = map;
    }


    private Map _instanceMap = new HashMap();
}
