/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;

import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.taglib.html.CCTextFieldTag;


/**
 *  This Descriptor is needed so that children of a CCPropertySheet can be
 *  created from the CCPropertySheet's model rather than directly.
 */
public class CCPropertySheetChildDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCPropertySheetChildDescriptor(String name) {
	super(name);
        addBeginDisplayHandler(this);
        //addEndDisplayHandler(this);
    }


    /**
     *	This method returns the model associated with this View (it is actually
     *	obtained from the parent ViewDescriptor).
     */
    protected CCPropertySheetModelInterface getModel() {
	return ((CCPropertySheetDescriptor)getParent()).getModel();
    }


    /**
     *	This is a factory method.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	CCPropertySheetModelInterface model = getModel();
	if (model != null && model.isChildSupported(name)) {
	    View child = model.createChild(container, name);
	    
	    if (child instanceof DisplayField) {
                DisplayField field = (DisplayField)child;

		// Set the binding
		setBoundName(field);

		// possibly set the default value from the view desc.
		setDefaultValue(child);
	    }

	    return child;
	}
	return null;
    }
    
    private void addBeginDisplayHandler(ViewDescriptor desc) {
        EventDescriptor ev = desc.getEventDescriptor(EventDescriptor.TYPES.BEGIN_DISPLAY);
        if (ev == null) {
            ev = new EventDescriptor(desc, EventDescriptor.TYPES.BEGIN_DISPLAY);
        }
        HandlerDescriptor hd = new HandlerDescriptor("beginFixTextDisplay");
        hd.setHandlerMethod(
            "com.sun.enterprise.tools.guiframework.event.handlers.ViewDescriptorHandlers", 
            "beginFixTextDisplay");

        UseHandlerDescriptor useDesc =  new UseHandlerDescriptor(ev, hd);
        ev.addEventHandler(useDesc);
        desc.setEventDescriptor(ev);
    }

//    private void addEndDisplayHandler(ViewDescriptor desc) {
//        EventDescriptor ev = desc.getEventDescriptor("endDisplay");
//        if (ev == null) {
//            ev = new EventDescriptor(desc, "endDisplay");
//            desc.setEventDescriptor(ev);
//        }
//        HandlerDescriptor hd = new HandlerDescriptor("endExtendedTextDisplay");
//        hd.setHandlerMethod(
//            "com.sun.enterprise.tools.guiframework.event.handlers.ViewDescriptorHandlers", 
//            "endFixTextDisplay");
//
//        UseHandlerDescriptor useDesc =  new UseHandlerDescriptor(ev, hd);
//        ev.addEventHandler(useDesc);
//    }
}
